! See copyright notice in the COPYRIGHT file.
?? include 'header/lbm_macros.inc'
?? include 'header/lbm_interfaceMacros.inc'
?? include 'treelm/source/logMacros.inc'
! ****************************************************************************** !
!> This module provides the definition and methods for
!! BGK advection relaxation scheme.
module mus_compute_nernstPlanck_module
  use iso_c_binding, only: c_f_pointer
  ! include treelm modules
  use env_module,               only: rk
  use tem_varSys_module,        only: tem_varSys_type !, tem_varSys_op_type
  use tem_param_module,         only: div1_3, div1_36, div1_8, div3_4h, div1_4,&
    &                                 div3_8, div9_16, div3_16, cs2inv, cs4inv,&
    &                                 rho0

  ! include musubi modules
  use mus_field_prop_module,     only: mus_field_prop_type
  use mus_scheme_layout_module,  only: mus_scheme_layout_type
  use mus_scheme_type_module,    only: mus_scheme_type
  use mus_param_module,          only: mus_param_type
  use mus_varSys_module,         only: mus_varSys_data_type

  implicit none

  private

  public :: mus_nernstPlanck_advRel_explicit

contains

! ****************************************************************************** !
  !> Advection relaxation routine for the 
  !! nernst planvk model with an explicit calculation of all equilibrium 
  !! quantities. Slow and simple. This routine should only be
  !! used for testing purposes
  !!
?? copy :: compute_routineHeader( mus_nernstPlanck_advRel_explicit )
?? copy :: compute_routineParams
    ! ---------------------------------------------------------------------------
    integer :: iElem, iDir, iField                       ! voxel element counter
    integer :: QQ, nScalars, nFields
    ! temporary distribution variables
    real(kind=rk) pdfTmp(layout%fStencil%QQ)
    real(kind=rk) inv_vel,transVel( nsolve*3 ), vel_fluid(3)   ! local velocit
    integer :: vel_varPos
    real(kind=rk) moleDens     ! local density
    ! derived constants
    ! equilibrium calculation variables
    real(kind=rk) ucx
    real(kind=rk) eqState
    real(kind=rk) omega
    type(mus_varSys_data_type), pointer :: fPtr
    type(mus_scheme_type), pointer :: scheme
    ! ---------------------------------------------------------------------------
    QQ = layout%fStencil%QQ
    ! nElems = size(neigh)/QQ
    nScalars = varSys%nScalars

    ! access scheme via 1st variable method data which is a state variable
    call C_F_POINTER( varSys%method%val(1)%method_Data, fPtr )
    scheme => fPtr%solverData%scheme
    nFields = scheme%nFields

    ! passive scalar has only one transport Variable
    vel_varPos = scheme%transVar%method(1)%data_varPos
    ! Get velocity field 
    call varSys%method%val(vel_varPos)%get_valOfIndex( &
      & varSys  = varSys,                              &
      & time    = params%general%simControl%now,       &
      & iLevel  = level,                               &
      & idx     = scheme%transVar%method(1)            &
      &           %pntIndex%indexLvl(level)            &
      &           %val(1:nSolve),                      &
      & nVals   = nSolve,                              &
      & res     = transVel                             )

    ! convert physical velocity into LB velocity
    inv_vel = 1.0_rk / params%physics%fac( level )%vel
    transVel = transVel * inv_vel


    fieldloop: do iField = 1, nFields
      !> relaxation parameter
      omega = fieldProp(iField)%species%omega
      nodeloop: do iElem=1, nSolve
        !> Generic fetching step:
        !! Streaming for pull
        !! Local copy for push
        do iDir = 1, QQ
          pdfTmp( iDir ) = inState(                                    &
            &?FETCH?( iDir, iField, iElem, QQ, nScalars, nElems,neigh) )
        end do
        
        ! mole density
        moleDens = sum(pdfTmp)
  
        ! x-, y- and z-velocity from transport field
        vel_fluid = transVel( (iElem-1)*3+1 : iElem*3 ) 
  
        do iDir = 1, QQ
  
          !> Pre-calculate velocitiy terms
          ucx = dble(layout%fStencil%cxDirRK( 1, iDir ))*vel_fluid(1) &
            & + dble(layout%fStencil%cxDirRK( 2, iDir ))*vel_fluid(2) &
            & + dble(layout%fStencil%cxDirRK( 3, iDir ))*vel_fluid(3)
  
          !> Calculate equilibrium distribution functions fEq
          eqState = layout%weight(iDir)*moleDens*( 1.0_rk + ucx*cs2inv )
          
          !> Relaxation
          outState( ?SAVE?( iDir, iField, iElem, QQ, nScalars, nElems,neigh )) &
            & = pdfTmp( iDir ) - omega*( pdfTmp(iDir ) - eqState )
        end do  !< iDir
  
      end do nodeloop
    end do fieldloop

  end subroutine mus_nernstPlanck_advRel_explicit
! ****************************************************************************** !

end module mus_compute_nernstPlanck_module
! ****************************************************************************** ! 

