! See copyright notice in the COPYRIGHT file.
??! QQ   = 9
??! Q__W = 1
??! Q__S = 2
??! Q__E = 3
??! Q__N = 4
??! Q_SW = 5
??! Q_NW = 6
??! Q_SE = 7
??! Q_NE = 8
??! Q__0 = 9
??!------------------------------------------------------------------------------
?? text :: var9( f )
  real(kind=rk) :: ?f?1
  real(kind=rk) :: ?f?2
  real(kind=rk) :: ?f?3
  real(kind=rk) :: ?f?4
  real(kind=rk) :: ?f?5
  real(kind=rk) :: ?f?6
  real(kind=rk) :: ?f?7
  real(kind=rk) :: ?f?8
  real(kind=rk) :: ?f?9
?? end text var9
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(in)  :: f(9)
??! real, intent(out) :: rho
?? text :: rho_d2q9_a( rho, f )
  ?rho? = ?f?(1) + ?f?(2) + ?f?(3) + ?f?(4) + ?f?(5) + &
    &     ?f?(6) + ?f?(7) + ?f?(8) + ?f?(9)
?? end text rho_d2q9_a
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(out) :: u_x, u_y
??! real, intent(in)  :: f(9), inv_rho
?? text :: vel_d2q9_a( u_x, u_y, f, inv_rho )
  ?u_x? = ?f?(3) + ?f?(7) + ?f?(8) - ?f?(1) - ?f?(5) - ?f?(6)
  ?u_y? = ?f?(4) + ?f?(6) + ?f?(8) - ?f?(2) - ?f?(5) - ?f?(7)

  ?u_x? = ?u_x? * ?inv_rho?
  ?u_y? = ?u_y? * ?inv_rho?
?? end text vel_d2q9_a
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
?? text :: var_fEq_d2q9
  real(kind=rk) :: usq, ucx, c0, c1, c2, c3
?? end text var_fEq_d2q9
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(out) :: fEq(9)
??! real, intent(in)  :: u_x, u_y, rho, rho0
??! real              :: usq, ucx, c0, c1, c2, c3
?? text :: fEq_d2q9_a( fEq, u_x, u_y, rho, rho0 )

  usq = ?u_x? * ?u_x? + ?u_y? * ?u_y?
  c0  = ?rho0? * cs2inv * cs2inv * div1_2
  c1  = ?rho? - ?rho0? * usq * div1_2 * cs2inv
  c2  = ?rho0? * cs2inv * ?u_x?
  c3  = ?rho0? * cs2inv * ?u_y?

  ?fEq?(9) = div4_9 * c1

  ?fEq?(1) = div1_9 * ( c1 - c2 + ?u_x?*?u_x?*c0 )
  ?fEq?(3) = ?fEq?(1) + div2_9 * c2

  ?fEq?(2) = div1_9 * ( c1 - c3 + ?u_y?*?u_y?*c0 )
  ?fEq?(4) = ?fEq?(2) + div2_9 * c3

  ucx = ?u_x?-?u_y?
  ?fEq?(6) = div1_36 * ( c1 - c2 + c3 + ucx*ucx*c0 )
  ?fEq?(7) = ?fEq?(6) + div1_18 * ( c2 - c3 )

  ucx = ?u_x?+?u_y?
  ?fEq?(5) = div1_36 * ( c1 - c2 - c3 + ucx*ucx*c0 )
  ?fEq?(8) = ?fEq?(5) + div1_18 * ( c2 + c3 )

?? end text fEq_d2q9_a
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(in)  :: f1 ... f9
??! real, intent(out) :: u_x
?? text :: rho_d2q9_s( rho, f )
  ?rho? = ?f?1 + ?f?2 + ?f?3 + ?f?4 + ?f?5 + &
    &     ?f?6 + ?f?7 + ?f?8 + ?f?9
?? end text rho_d2q9_s
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(in)  :: f1 ... f9
??! real, intent(out) :: u_x
?? text :: ux_d2q9_s( u_x, f, inv_rho )
      ?u_x? =   ?f?3 + ?f?7 + ?f?8 &
        &     - ?f?1 - ?f?5 - ?f?6

      ?u_x? = ?u_x? * ?inv_rho?
?? end text ux_d2q9_s
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(in)  :: f1 ... f9
??! real, intent(out) :: u_y
?? text :: uy_d2q9_s( u_y, f, inv_rho )
      ?u_y? =   ?f?4 + ?f?6 + ?f?8 &
        &     - ?f?2 - ?f?5 - ?f?7

      ?u_y? = ?u_y? * ?inv_rho?
?? end text uy_d2q9_s
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
??! real, intent(out) :: fEq1 ... fEq9
??! real, intent(in)  :: u_x, u_y, rho, rho0
??! real              :: usq, ucx, c0, c1, c2, c3
?? text :: fEq_d2q9_s( fEq, u_x, u_y, rho, rho0, usq, ucx, c0, c1, c2, c3 )

  ?usq? = ?u_x? * ?u_x? + ?u_y? * ?u_y?
  ?c1? = ?rho? - ?rho0? * ?usq? * div1_2 * cs2inv
  ?fEq?9 = div4_9 * ?c1?

  ?c0? = ?rho0? * cs2inv * cs2inv * div1_2
  ?c2? = ?rho0? * cs2inv * ?u_x?
  ?c3? = ?rho0? * cs2inv * ?u_y?

  ?fEq?1 = div1_9 * ( ?c1? - ?c2? + ?u_x?*?u_x?*?c0? )
  ?fEq?3 = ?fEq?1 + div2_9 * ?c2?

  ?fEq?2 = div1_9 * ( ?c1? - ?c3? + ?u_y?*?u_y?*?c0? )
  ?fEq?4 = ?fEq?2 + div2_9 * ?c3?

  ?ucx?  = ?u_x?+?u_y?
  ?fEq?5 = div1_36 * ( ?c1? - ?c2? - ?c3? + ?ucx?*?ucx?*?c0? )
  ?fEq?8 = ?fEq?5 + div1_18 * ( ?c2? + ?c3? )

  ?ucx?  = ?u_x?-?u_y?
  ?fEq?6 = div1_36 * ( ?c1? - ?c2? + ?c3? + ?ucx?*?ucx?*?c0? )
  ?fEq?7 = ?fEq?6 + div1_18 * ( ?c2? - ?c3? )


?? end text fEq_d2q9_s
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
?? text :: S_d2q9_a( Sxx, Syy, Sxy, fNeq, rho, omega, c0 )

  ?Sxx? =   ?fNeq?(3) + ?fNeq?(7) + ?fNeq?(8) &
    &     + ?fNeq?(1) + ?fNeq?(5) + ?fNeq?(6)

  ?Syy? =   ?fNeq?(2) + ?fNeq?(8) + ?fNeq?(6) &
    &     + ?fNeq?(4) + ?fNeq?(5) + ?fNeq?(7)

  ?Sxy? =   ?fNeq?(8) + ?fNeq?(5) - ?fNeq?(6) - ?fNeq?(7)

  ?c0?  = -1.5_rk * ?omega? * ?rho?
  ?Sxx? = ?Sxx? * ?c0?
  ?Syy? = ?Syy? * ?c0?
  ?Sxy? = ?Sxy? * ?c0?

?? end text S_d2q9_a
??!------------------------------------------------------------------------------
??!
??!------------------------------------------------------------------------------
?? text :: S_d2q9_s( Sxx, Syy, Sxy, fNeq, rho, omega, c0 )

  ?Sxx? = ?fNeq?3 + ?fNeq?7 + ?fNeq?8 + ?fNeq?1 + ?fNeq?5 + ?fNeq?6
  ?Syy? = ?fNeq?2 + ?fNeq?8 + ?fNeq?6 + ?fNeq?4 + ?fNeq?5 + ?fNeq?7
  ?Sxy? = ?fNeq?8 + ?fNeq?5 - ?fNeq?6 - ?fNeq?7

  ?c0?  = -1.5_rk * ?omega? * ?rho?

  ?Sxx? = ?Sxx? * ?c0?
  ?Syy? = ?Syy? * ?c0?
  ?Sxy? = ?Sxy? * ?c0?

?? end text S_d2q9_s
??!------------------------------------------------------------------------------
