! See copyright notice in the COPYRIGHT file.
?? text :: vel_d3q19( u_x, u_y, u_z, f, inv_rho )
    ?u_x? =   ?f?(18) + ?f?(17) + ?f?( 4) &
      &     + ?f?(14) + ?f?(12)           &
      &     - ?f?(16) - ?f?( 1) - ?f?(15) &
      &     - ?f?(13) - ?f?(11)

    ?u_y? =   ?f?(18) + ?f?( 5) + ?f?(16) &
      &     + ?f?(10) + ?f?( 9)           &
      &     - ?f?(15) - ?f?( 2) - ?f?(17) &
      &     - ?f?( 8) - ?f?( 7)

    ?u_z? =   ?f?( 6) + ?f?(14) + ?f?(10) &
      &     + ?f?(13) + ?f?( 8)           &
      &     - ?f?( 3) - ?f?(12) - ?f?( 9) &
      &     - ?f?(11) - ?f?( 7)

    ?u_x? = ?u_x? * ?inv_rho?
    ?u_y? = ?u_y? * ?inv_rho?
    ?u_z? = ?u_z? * ?inv_rho?
?? end text vel_d3q19
??!
?? text :: rho_d3q19_a( rho, f )
    ?rho? = ?f?(1)  + ?f?(2)  + ?f?(3)  + ?f?(4)  + ?f?(5)  + &
      &     ?f?(6)  + ?f?(7)  + ?f?(8)  + ?f?(9)  + ?f?(10) + &
      &     ?f?(11) + ?f?(12) + ?f?(13) + ?f?(14) + ?f?(15) + &
      &     ?f?(16) + ?f?(17) + ?f?(18) + ?f?(19)
?? end text rho_d3q19_a
??!
?? text :: fEq_d3q19_var
    real(kind=rk) :: usq, usqn, usqn_o2
    real(kind=rk) :: coeff_1, coeff_2
    real(kind=rk) :: ui1, ui3, ui10, ui11, ui12, ui13
    real(kind=rk) :: fac_1, fac_2, fac_3, fac_4, fac_9, fac_10, fac_11, fac_12,&
      &              fac_13
    real(kind=rk) :: sum1_1, sum1_2, sum2_1, sum2_2, sum3_1, sum3_2, sum4_1,   &
      &              sum4_2, sum9_1, sum9_2, sum10_1, sum10_2, sum11_1,        &
      &              sum11_2, sum12_1, sum12_2, sum13_1, sum13_2
?? end text fEq_d3q19_var
??!
?? text :: fEq_d3q19_a( fEq, u_x, u_y, u_z, rho, rho0 )
  usq  = ?u_x?*?u_x? + ?u_y?*?u_y? + ?u_z?*?u_z?
  usqn = div1_36 * (?rho? - 1.5d0 * usq * ?rho0?)

  ?fEq?(19) = 12.0d0 * usqn

  coeff_1 = 0.125d0 * ?rho0?

  ui1     =  ?u_x? + ?u_y?
  fac_1   = coeff_1 * ui1
  sum1_1  = fac_1 * div3_4h
  sum1_2  = fac_1 * ui1 + usqn

  ?fEq?(18) =  sum1_1 +sum1_2
  ?fEq?(15) = -sum1_1 +sum1_2

  ui3     = -?u_x? + ?u_y?
  fac_3   = coeff_1 * ui3
  sum3_1  = fac_3 * div3_4h
  sum3_2  = fac_3 * ui3 + usqn

  ?fEq?(16) =  sum3_1 +sum3_2
  ?fEq?(17) = -sum3_1 +sum3_2

  ui10    =  ?u_x? + ?u_z?
  fac_10  = coeff_1 * ui10
  sum10_1 = fac_10 * div3_4h
  sum10_2 = fac_10 * ui10 + usqn

  ?fEq?(14) =  sum10_1+sum10_2
  ?fEq?(11) = -sum10_1+sum10_2

  ui12    = -?u_x? + ?u_z?
  fac_12  = coeff_1 * ui12
  sum12_1 = fac_12 * div3_4h
  sum12_2 = fac_12 * ui12 + usqn

  ?fEq?(13) =  sum12_1+sum12_2
  ?fEq?(12) = -sum12_1+sum12_2

  ui11    =  ?u_y? + ?u_z?
  fac_11  = coeff_1 * ui11
  sum11_1 = fac_11 * div3_4h
  sum11_2 = fac_11 * ui11 + usqn

  ?fEq?(10) =  sum11_1+sum11_2
  ?fEq?( 7) = -sum11_1+sum11_2

  ui13    = -?u_y? + ?u_z?
  fac_13  = coeff_1 * ui13
  sum13_1 = fac_13 * div3_4h
  sum13_2 = fac_13 * ui13 + usqn

  ?fEq?( 8) =  sum13_1+sum13_2
  ?fEq?( 9) = -sum13_1+sum13_2

  coeff_2 = 0.25d0 * ?rho0?
  usqn_o2 = 2.0d0 * usqn

  fac_2   = coeff_2 * ?u_y?
  sum2_1  = fac_2 * div3_4h
  sum2_2  = fac_2 * ?u_y? + usqn_o2

  ?fEq?( 5) =  sum2_1 +sum2_2
  ?fEq?( 2) = -sum2_1 +sum2_2

  fac_4   = coeff_2 * ?u_x?
  sum4_1  = fac_4 * div3_4h
  sum4_2  = fac_4 * ?u_x? + usqn_o2

  ?fEq?( 1) = -sum4_1 +sum4_2
  ?fEq?( 4) =  sum4_1 +sum4_2

  fac_9   = coeff_2 * ?u_z?
  sum9_1  = fac_9 * div3_4h
  sum9_2  = fac_9 * ?u_z? + usqn_o2

  ?fEq?( 6) =  sum9_1 +sum9_2
  ?fEq?( 3) = -sum9_1 +sum9_2

?? end text fEq_d3q19_a
??!
?? text :: pdfTmp19( f )
  real(kind=rk) :: ?f?N00
  real(kind=rk) :: ?f?0N0
  real(kind=rk) :: ?f?00N
  real(kind=rk) :: ?f?100
  real(kind=rk) :: ?f?010
  real(kind=rk) :: ?f?001
  real(kind=rk) :: ?f?0NN
  real(kind=rk) :: ?f?0N1
  real(kind=rk) :: ?f?01N
  real(kind=rk) :: ?f?011
  real(kind=rk) :: ?f?N0N
  real(kind=rk) :: ?f?10N
  real(kind=rk) :: ?f?N01
  real(kind=rk) :: ?f?101
  real(kind=rk) :: ?f?NN0
  real(kind=rk) :: ?f?N10
  real(kind=rk) :: ?f?1N0
  real(kind=rk) :: ?f?110
  real(kind=rk) :: ?f?000
?? end text pdfTmp19
??!
?? text :: rho_d3q19( rho, f )
  ?rho? =   ?f?000                      &
          + ?f?110 + ?f?010 + ?f?N10 + ?f?N00 &
          + ?f?NN0 + ?f?0N0 + ?f?1N0 + ?f?100 &
          + ?f?001 + ?f?101 + ?f?011 + ?f?N01 &
          + ?f?0N1 + ?f?00N + ?f?10N + ?f?01N &
          + ?f?N0N + ?f?0NN
?? end text rho_d3q19
??!
?? text :: ux_d3q19( ux, f, inv_rho )
  ?ux? =   ??f??100 + ??f??10N + ??f??101 + ??f??1N0 + ??f??110 &
    &    - ?f?N00 - ?f?N0N - ?f?N01 - ?f?NN0 - ?f?N10
  ?ux? = ?ux? * ?inv_rho?
?? end text ux_d3q19
??!
?? text :: uy_d3q19( uy, f, inv_rho )
  ?uy? =   ?f?010 + ?f?01N + ?f?011 + ?f?N10 + ?f?110 &
    &    - ?f?0N0 - ?f?0NN - ?f?0N1 - ?f?NN0 - ?f?1N0
  ?uy? = ?uy? * ?inv_rho?
?? end text uy_d3q19
??!
?? text :: uz_d3q19( uz, f, inv_rho )
  ?uz? =   ?f?001 + ?f?0N1 + ?f?011 + ?f?N01 + ?f?101 &
    &    - ?f?00N - ?f?0NN - ?f?01N - ?f?N0N - ?f?10N
  ?uz? = ?uz? * ?inv_rho?
?? end text uz_d3q19
??!
?? text :: var19( f )
  real(kind=rk) :: ?f?1
  real(kind=rk) :: ?f?2
  real(kind=rk) :: ?f?3
  real(kind=rk) :: ?f?4
  real(kind=rk) :: ?f?5
  real(kind=rk) :: ?f?6
  real(kind=rk) :: ?f?7
  real(kind=rk) :: ?f?8
  real(kind=rk) :: ?f?9
  real(kind=rk) :: ?f?10
  real(kind=rk) :: ?f?11
  real(kind=rk) :: ?f?12
  real(kind=rk) :: ?f?13
  real(kind=rk) :: ?f?14
  real(kind=rk) :: ?f?15
  real(kind=rk) :: ?f?16
  real(kind=rk) :: ?f?17
  real(kind=rk) :: ?f?18
  real(kind=rk) :: ?f?19
?? end text var19
??!
?? text :: second_moment_d3q19( fNeq, s )

      sss        = - (?s?(1)+?s?(2)+?s?(3)) * cs2

      ?fNeq?( 1) = ?s?(1) + sss
      ?fNeq?( 2) = ?s?(2) + sss
      ?fNeq?( 3) = ?s?(3) + sss
      ?fNeq?( 4) = ?fNeq?( 1)
      ?fNeq?( 5) = ?fNeq?( 2)
      ?fNeq?( 6) = ?fNeq?( 3)

      ?fNeq?( 7) = ?s?(2) + ?s?(3) + sss + ?s?(5) * 2.0_rk
      ?fNeq?( 8) = ?s?(2) + ?s?(3) + sss - ?s?(5) * 2.0_rk
      ?fNeq?( 9) = ?fNeq?( 8)
      ?fNeq?(10) = ?fNeq?( 7)

      ?fNeq?(11) = ?s?(1) + ?s?(3) + sss + ?s?(6) * 2.0_rk
      ?fNeq?(12) = ?s?(1) + ?s?(3) + sss - ?s?(6) * 2.0_rk
      ?fNeq?(13) = ?fNeq?(12)
      ?fNeq?(14) = ?fNeq?(11)

      ?fNeq?(15) = ?s?(1) + ?s?(2) + sss + ?s?(4) * 2.0_rk
      ?fNeq?(16) = ?s?(1) + ?s?(2) + sss - ?s?(4) * 2.0_rk
      ?fNeq?(17) = ?fNeq?(16)
      ?fNeq?(18) = ?fNeq?(15)

      ?fNeq?(19) = sss

?? end text second_moment_d3q19
