??!----------- Compute kernel parameters ------------------------------------
?? text :: compute_routineParams
    !---------------------------------------------------------------------------
    !> Array of field properties (fluid or species)
    type(mus_field_prop_type), intent(in) :: fieldProp(:)
    !> variable system definition
    type(tem_varSys_type), intent(in) :: varSys
    !> current layout
    type(mus_scheme_layout_type), intent(in) :: layout
    !> number of elements in state Array
    integer, intent(in) :: nElems
    !> input  pdf vector
    real(kind=rk), intent(in)  ::  inState(nElems * varSys%nScalars)
    !> output pdf vector
    real(kind=rk), intent(out) :: outState(nElems * varSys%nScalars)
    !> Auxiliary field computed from pre-collision state
    !! Is updated with correct velocity field for multicomponent models
    real(kind=rk), intent(inout) :: auxField(nElems * varSys%nAuxScalars)
    !> connectivity vector
    integer, intent(in) :: neigh(nElems * layout%fStencil%QQ)
    !> number of elements solved in kernel
    integer, intent(in) :: nSolve
    !> current level
    integer,intent(in) :: level
    !> global parameters
    type(mus_param_type),intent(in) :: params
?? end text compute_routineParams
??!----------- Compute kernel parameters ------------------------------------
??!
??!----------- Compute kernel header ------------------------------
?? text :: compute_routineHeader( computeName )
  !> This interface definition must match the compute kernel header interfaces
  !! defined in scheme/mus_scheme_type_module.f90
  subroutine ?computeName?(  fieldProp, inState, outState,  auxField, &
    &                        neigh, nElems, nSolve, level, layout,   &
    &                        params, varSys )
?? end text compute_routineHeader
??!----------- Compute kernel header ------------------------------
??!
??!----------- Boundary header
?? text :: bc_routineHeader( bcName )
  !> This interface definition must match the boundary header interfaces
  !! defined in bc/mus_bc_header_module.f90
  subroutine ?bcName?( me, state, bcBuffer, globBC, levelDesc, tree, nSize,  &
    & iLevel, sim_time, neigh, layout, fieldProp, varPos, nScalars, varSys,    &
    & derVarPos, physics, iField, mixture )
    !---------------------------------------------------------------------------
    class(boundary_type) :: me     !< global boundary type
    !> Current state vector of iLevel
    real(kind=rk),intent(inout) :: state(:)
    !> size of state array ( in terms of elements )
    integer, intent(in) :: nSize
    !> state values of boundary elements of All fields of iLevel
    real(kind=rk),intent(in) :: bcBuffer(:)
    !> iLevel descriptor
    Type( tem_levelDesc_type), intent(in) :: levelDesc
    !> Treelm Mesh
    Type( treelmesh_type ), intent(in) ::tree
    !> fluid parameters and properties
    Type( mus_field_prop_type ), intent(in) :: fieldProp
    !> stencil layout information
    Type( mus_scheme_layout_type ),intent(in) ::layout
    !> the level On which this boundary was invoked
    integer,intent(in) :: iLevel
    !> connectivity Array corresponding to state vector
    integer,intent(in) :: neigh(:)
    !> global time information
    type( tem_time_type ), intent(in)  :: sim_time
    !> global parameters
    ! type( mus_param_type ),intent(in) :: params
    !> pointer to field variable in the state vector
    integer, intent(in) :: varPos(:)
    !> number of Scalars in the scheme var system
    integer, intent(in) :: nScalars
    !> scheme variable system
    type( tem_varSys_type ), intent(in) :: varSys
    !> position of derived quantities in varsys
    type( mus_derVarPos_type ), intent(in) :: derVarPos
    !> scheme global boundary type
    type( glob_boundary_type ), intent(in) :: globBC
    !> scheme global boundary type
    type( mus_physics_type ), intent(in) :: physics
    !> current field
    integer, intent(in) :: iField
    !> mixture info
    type(mus_mixture_type), intent(in) :: mixture
?? end text bc_routineHeader
??!
??!----------- Interpolation header
?? text :: interpolateRoutine_header( intpName )
  !> This interface definition must match the interpolation header interfaces
  !! defined in intp/mus_interpolate_header_module.f90
  subroutine ?intpName?( method, tLevelDesc, level, sState, snSize, &
    & tState, tnSize, tAuxField, layout, nTargets, targetList, physics, &
    & time, varSys, derVarPos )

    class(mus_interpolation_method_type), intent(in) :: method

    !> level descriptor on target level
    type( tem_levelDesc_type ), intent(in) :: tLevelDesc

    !> my refinement level
    integer, intent(in) :: level

    !> State vector of SOURCE FLUID elements
    real(kind=rk), intent(in) :: sState(:)
    ! integer,       intent(in) :: sNeigh(:)
    integer,       intent(in) :: snSize

    !> State vector of TARGET GHOST elements
    real(kind=rk), intent(inout) :: tState(:)
    ! integer,       intent(in) :: tNeigh(:)
    integer,       intent(in) :: tnSize

    !> AuxField variable to fill on target GHOST elements
    real(kind=rk), intent(inout) :: tAuxField(:)

    !> the layout used
    type( mus_scheme_layout_type ), intent(in) :: layout

    !> List of target elements ( their position in depSource list )
    integer, intent(in) :: nTargets
    integer, intent(in) :: targetList(nTargets)

    !> physics type to convert lattice to physics SI unit and vice versa
    !! @todo: This can be replaced by scale factor by level
    type( mus_physics_type ), intent(in) :: physics

    !> time required to compute viscosity on target element barycenter
    type(tem_time_type), intent(in) :: time

    !> scheme variable system
    type( tem_varSys_type ), intent(in) :: varSys

    !> position of all derive variable in varSys
    type(mus_derVarPos_type), intent(in) :: derVarPos(:)
?? end text interpolateRoutine_header
??!
??!
??!----------- Interpolation header
?? text :: interpolateRoutineArbi_header( intpName )
  !> This interface definition must match the interpolation header interfaces
  !! defined in intp/mus_interpolate_header_module.f90
  subroutine ?intpName?( method, tLevelDesc, level, stencil, sVal, snSize, &
    & tVal, tnSize, nTargets, targetList, nScalars )

    class(mus_interpolation_method_type), intent(in) :: method

    !> my refinement level
    integer, intent(in) :: level

    !> stencil header
    type(tem_stencilHeader_type), intent(in) :: stencil

    !> State vector of SOURCE FLUID elements
    real(kind=rk), intent(in) :: sVal(:)
    integer,       intent(in) :: snSize

    !> State vector of TARGET GHOST elements
    real(kind=rk), intent(inout) :: tVal(:)
    integer,       intent(in) :: tnSize

    !> level descriptor on target level
    type( tem_levelDesc_type ), intent(in) :: tLevelDesc

    !> List of target elements ( their position in depSource list )
    integer, intent(in) :: nTargets
    integer, intent(in) :: targetList(nTargets)

    !> number of scalars to interpolate
    integer, intent(in) :: nScalars
?? end text interpolateRoutineArbi_header
??!
??!----------- derive from macro header
?? text :: deriveFromMacro_header( deriveName )
  !> This interface definition must match the derive_FromMacro header interfaces
  !! defined in mus_variable_module
  subroutine ?deriveName?( density, velocity, iField, nElems, varSys, &
      &                    layout, res )
      !> Array of density.
      !! Single species: dens_1, dens_2 .. dens_n
      !! multi-species: dens_1_sp1, dens_1_sp2, dens_2_sp1, dens_2_sp2 ...
      !!                dens_n_sp1, dens_n_sp2
      real(kind=rk), intent(in) :: density(:)

      !> Array of velocity.
      !! Size: dimension 1: n*nFields. dimension 2: 3 (nComp)
      !! 1st dimension arrangement for multi-species is same as density
      real(kind=rk), intent(in) :: velocity(:, :)

      !> Current field
      integer, intent(in) :: iField

      !> number of elements
      integer, intent(in) :: nElems

      !> variable system which is required to access fieldProp
      !! information via variable method data c_ptr
      type(tem_varSys_type), intent(in) :: varSys

      !> scheme layout contains stencil definition and lattice weights
      type(mus_scheme_layout_type), intent(in) :: layout

      !> Output of this routine
      !! Dimension: n*nComponents of res
      real(kind=rk), intent(out) :: res(:)
?? end text deriveFromMacro_header
??!
??!
??!----------- derive from state header
?? text :: deriveFromState_header( deriveName )
  !> This interface definition must match the derive_FromState header interfaces
  !! defined in mus_variable_module
  subroutine ?deriveName?( state, iField, nElems, varSys, layout, res )
      !> Array of state
      !! n * layout%fStencil%QQ * nFields
      real(kind=rk), intent(in) :: state(:)

      !> Current field
      integer, intent(in) :: iField

      !> number of elements
      integer, intent(in) :: nElems

      !> variable system which is required to access fieldProp
      !! information via variable method data c_ptr
      type(tem_varSys_type), intent(in) :: varSys

      !> scheme layout contains stencil definition and lattice weights
      type(mus_scheme_layout_type), intent(in) :: layout

      !> Output of this routine
      !! Dimension: n * nComponents of res
      real(kind=rk), intent(out) :: res(:)
?? end text deriveFromState_header
??!
??!
??!----------- derive from pre-collision state header
?? text :: deriveFromPreColState_header( deriveName )
  !> This interface definition must match the derive_FromState header interfaces
  !! defined in mus_variable_module
  subroutine ?deriveName?( state, neigh, iField, nSize, nElems, varSys, &
    &                      layout, res )
      !> Array of state
      !! n * layout%fStencil%QQ * nFields
      real(kind=rk), intent(in) :: state(:)

      !> connectivity array
      integer, intent(in) :: neigh(:)

      !> Current field
      integer, intent(in) :: iField

      !> number of elements in state array 
      integer, intent(in) :: nSize

      !> number of elements
      integer, intent(in) :: nElems

      !> variable system which is required to access fieldProp
      !! information via variable method data c_ptr
      type(tem_varSys_type), intent(in) :: varSys

      !> scheme layout contains stencil definition and lattice weights
      type(mus_scheme_layout_type), intent(in) :: layout

      !> Output of this routine
      !! Dimension: n * nComponents of res
      real(kind=rk), intent(out) :: res(:)
?? end text deriveFromPreColState_header
??!
??!-----------derive aux from local state 
?? text :: deriveAuxFromState_header( deriveName )
  !> This interface definition must match the derive_auxFromState header interfaces
  !! defined in mus_variable_module
  subroutine ?deriveName?( derVarPos, state, iField, nElems, nSize, iLevel, &
    &                      stencil, varSys, auxField )
    !> Position of derive variable in variable system
    class(mus_derVarPos_type), intent(in) :: derVarPos
    !> Array of state
    !! n * layout%stencil(1)%QQ * nFields
    real(kind=rk), intent(in) :: state(:)

    !> Current field
    integer, intent(in) :: iField

    !> number of elements
    integer, intent(in) :: nElems

    !> number of elements in state array
    integer, intent(in) :: nSize

    !> current level
    integer, intent(in) :: iLevel

    !> stencil header contains discrete velocity vectors
    type(tem_stencilHeader_type), intent(in) :: stencil

    !> variable system which is required to access fieldProp
    !! information via variable method data c_ptr
    type(tem_varSys_type), intent(in) :: varSys

    !> Output of this routine
    !! Size: nElems*nAuxScalars 
    real(kind=rk), intent(inout) :: auxField(:)
?? end text deriveAuxFromState_header
??!
??!
??!-----------derive Equilibrirm from aux
?? text :: deriveEquilFromAux_header( deriveName )
  !> This interface definition must match the derive_equilFromAux header interfaces
  !! defined in mus_variable_module
  subroutine ?deriveName?( derVarPos, auxField, iField, nElems, &
    &                      varSys, layout, fEq )
    !> Position of derive variable in variable system
    class(mus_derVarPos_type), intent(in) :: derVarPos
    !> Array of auxField.
    !! Single species: dens_1, vel_1, dens_2, vel_2, .. dens_n, vel_n
    !! multi-species: dens_1_sp1, vel_1_spc1, dens_1_sp2, vel_1_spc2, 
    !!                dens_2_sp1, vel_2_spc2, dens_2_sp2, vel_2_spc2 ...
    !!                dens_n_sp1, vel_n_sp1, dens_n_sp2, vel_n_spc2
    !! Access: (iElem-1)*nAuxScalars + auxField_varPos
    real(kind=rk), intent(in) :: auxField(:)

    !> Current field
    integer, intent(in) :: iField

    !> number of elements
    integer, intent(in) :: nElems

    !> variable system which is required to access fieldProp
    !! information via variable method data c_ptr
    type(tem_varSys_type), intent(in) :: varSys

    !> scheme layout contains stencil definition and lattice weights
    type(mus_scheme_layout_type), intent(in) :: layout

    !> Output of this routine
    !! Dimension: n*QQ of res
    real(kind=rk), intent(out) :: fEq(:)
?? end text deriveEquilFromAux_header
??!
??!----------- apply source
?? text :: applySource_header( sourceName )
  !> This interface definition must match the derive_FromState header interfaces
  !! defined in mus_variable_module
  subroutine ?sourceName?( fun, inState, outState, neigh, auxField, nPdfSize, &
    &                      iLevel, varSys, time, phyConvFac, derVarPos )
    !---------------------------------------------------------------------------
    !> Description of method to apply source terms
    class(mus_source_op_type), intent(in) :: fun

    !> input  pdf vector
    real(kind=rk), intent(in)  ::  inState(:)

    !> output pdf vector
    real(kind=rk), intent(inout) :: outState(:)

    !> connectivity Array corresponding to state vector
    integer,intent(in) :: neigh(:)

    !> auxField array
    real(kind=rk), intent(in) :: auxField(:)

    !> number of elements in state Array
    integer, intent(in) :: nPdfSize

    !> current level
    integer, intent(in) :: iLevel

    !> variable system 
    type(tem_varSys_type), intent(in) :: varSys

    !> Point in time at which to evaluate the variable.
    type(tem_time_type), intent(in)  :: time

    !> Physics conversion factor for current level
    type(mus_convertFac_type), intent(in) :: phyConvFac

    !> position of derived quantities in varsys
    type(mus_derVarPos_type), intent(in) :: derVarPos(:)
    !--------------------------------------------------------------------------- 
?? end text applySource_header
