! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines which initiliaze advection relaxation and
!! flow field for lbm model for acoustic equations.
module mus_initIsothermAcEq_module
  use env_module,         only: labelLen
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  use mus_isotherm_acEq_module, only: bgk_advRel_isotherm_acEq_d3q19
  use mus_scheme_type_module,   only: kernel

  implicit none

  private

  public :: mus_init_advRel_isotherm_acEq

contains

  ! **************************************************************************** !
  !> Assigning compute kernel routine by scheme relaxation type for
  !> isotherm_acEq kind.
  !!
  subroutine mus_init_advRel_isotherm_acEq( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(inout) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------

    write(logUnit(1),*) 'Choosing relaxation model: '//trim( relaxation )
    select case( trim( relaxation ))
    case( 'bgk' )
      select case( trim(layout) )
      case( 'd3q19' )
        compute => bgk_advRel_isotherm_acEq_d3q19
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case default
      write(logUnit(1),*) 'Relaxation '//trim(relaxation)//' is not supported!'
      call tem_abort()
    end select

  end subroutine mus_init_advRel_isotherm_acEq
  ! **************************************************************************** !

end module mus_initIsothermAcEq_module
! ****************************************************************************** !
