! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines which initiliaze advection relaxation and
!! flow field for lbm model.
module mus_initLBMnNwtn_module

  use env_module,         only: labelLen
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  use mus_bgk_module, only: bgk_nNwtn_PL_explicit, &
    &                       bgk_nNwtn_CY_explicit, &
    &                       bgk_nNwtn_CS_explicit
  use mus_d2q9_module, only: bgk_d2q9_nNwtn_pl
  use mus_d3q19_module, only: bgk_advRel_d3q19_nNwtn_PL,  &
    &                         bgk_advRel_d3q19_nNwtn_CY,  &
    &                         bgk_advRel_d3q19_nNwtn_CS,  &
    &                         bgk_advRel_d3q19_incomp_nNwtn_PL,  &
    &                         bgk_advRel_d3q19_incomp_nNwtn,  &
    &                         bgk_advRel_d3q19_incomp_nNwtn_CY
  use mus_scheme_type_module, only: kernel

  implicit none

  private

  public :: mus_init_advRel_LBM_nNwtn
  public :: mus_init_advRel_LBM_incomp_nNwtn

contains

  ! **************************************************************************** !
  !> Assigning compute kernel routine by scheme relaxation type for LBM kind
  !!
  subroutine mus_init_advRel_LBM_nNwtn( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(in) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------

    select case( trim( relaxation ))
    case( 'bgk_pl' ) ! BGK with nonNewtonian Power Law

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_nNwtn_PL
        write(logUnit(3),*)' Choose nonNewtonian Power Law kernel.'
      elseif ( trim(layout) == 'd2q9' ) then
        compute => bgk_d2q9_nNwtn_PL
        write(logUnit(3),*)' Choose BGK d2q9 nonNewtonian Power Law kernel.'
      else
        compute => bgk_nNwtn_PL_explicit
        write(logUnit(3),*)' nonNewtonian optimized kernel only support D3Q19.'
        write(logUnit(3),*) 'Choose nonNewtonian Power Law explicit kernel.'
      end if

    case( 'bgk_cy' ) ! BGK with nonNewtonian Carreau-Yasuda

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_nNwtn_CY
        write(logUnit(3),*)' Choose nonNewtonian Carraue-Yasuda kernel.'
      else
        compute => bgk_nNwtn_CY_explicit
        write(logUnit(3),*)' nonNewtonian optimized kernel only support D3Q19.'
        write(logUnit(3),*)'Choose nonNewtonian Carreau-Yasuda explicit kernel.'
      end if

    case( 'bgk_cs' ) ! BGK with nonNewtonian Casson

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_nNwtn_CS
        write(logUnit(3),*)' Choosed nonNewtonian Casson compute kernel.'
      else
        write(logUnit(1),*) 'The selected layout model is not supported!'
        call tem_abort()
      end if

    case( 'bgk_pl_explicit' )

      compute => bgk_nNwtn_PL_explicit
      write(logUnit(3),*) 'Choosed nonNewtonian Power Law explicit kernel.'

    case( 'bgk_cy_explicit' )

      compute => bgk_nNwtn_CY_explicit
      write(logUnit(3),*) 'Choosed nonNewtonian Carreau-Yasuda explicit kernel.'

    case( 'bgk_cs_explicit' )

      compute => bgk_nNwtn_CS_explicit
      write(logUnit(3),*) 'Choosed nonNewtonian Casson explicit kernel.'

    case default

      write(logUnit(1),*) 'The selected relaxation model is not supported!'
      call tem_abort()

    end select

  end subroutine mus_init_advRel_LBM_nNwtn
  ! ****************************************************************************** !

  ! **************************************************************************** !
  !> Assigning compute kernel routine by scheme relaxation type for LBM kind
  !!
  subroutine mus_init_advRel_LBM_incomp_nNwtn( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(in) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------

    select case( trim( relaxation ))
    case( 'bgk_pl' ) ! BGK with nonNewtonian Power Law

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_incomp_nNwtn_PL
        write(logUnit(3),*)' Choose D3Q19 incomp nonNewtonian Power Law kernel.'
      else
        ! compute => bgk_nNwtn_PL_explicit
        ! write(logUnit(3),*)' nonNewtonian optimized kernel only support D3Q19.'
        ! write(logUnit(3),*) 'Choose nonNewtonian Power Law explicit kernel.'
        write(logUnit(1),*) 'The selected relaxation model is not supported!'
        call tem_abort()
      end if

    case( 'bgk_cy' ) ! BGK with nonNewtonian Carreau-Yasuda

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_incomp_nNwtn_CY
        write(logUnit(3),*)' Choose D3Q19 incomp nonNewtonian Carraue-Yasuda kernel.'
      else
        ! compute => bgk_nNwtn_CY_explicit
        ! write(logUnit(3),*)' nonNewtonian optimized kernel only support D3Q19.'
        ! write(logUnit(3),*)'Choose nonNewtonian Carreau-Yasuda explicit kernel.'
        write(logUnit(1),*) 'The selected relaxation model is not supported!'
        call tem_abort()
      end if

    ! case( 'bgk_cs' ) ! BGK with nonNewtonian Casson

    !   if ( trim(layout) == 'd3q19' ) then
    !     compute => bgk_advRel_d3q19_incomp_nNwtn_CS
    !     write(logUnit(3),*)' Choosed nonNewtonian Casson compute kernel.'
    !   else
    !     write(logUnit(1),*) 'The selected layout model is not supported!'
    !     call tem_abort()
    !   end if

    case( 'bgk' )

      if ( trim(layout) == 'd3q19' ) then
        compute => bgk_advRel_d3q19_incomp_nNwtn
        write(logUnit(3),*)' Choosed nonNewtonian.'
      else
        write(logUnit(1),*) 'The selected layout model is not supported!'
        call tem_abort()
      end if

    case default

      write(logUnit(1),*) 'The selected relaxation model is not supported!'
      call tem_abort()

    end select

  end subroutine mus_init_advRel_LBM_incomp_nNwtn
  ! ****************************************************************************** !

end module mus_initLBMnNwtn_module
! ****************************************************************************** !
