! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines which initiliaze advection relaxation and
!! flow field for lbm incompressible model.
module mus_initNernstPlanck_module
  ! include treelm modules
  use env_module,         only: labelLen
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  ! include musubi modules
  use mus_compute_nernstPlanck_module,  only: mus_nernstPlanck_advRel_explicit 
  use mus_scheme_type_module,           only: kernel

  implicit none

  private

  public :: mus_init_advRel_nernstPlanck

contains

  ! ************************************************************************** !
  !> Initialize the relaxation model for lbm poisson equation
  subroutine mus_init_advRel_nernstPlanck( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(inout) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------
    write(logUnit(1),*) 'Choosing relaxation model for nernst_planck: ' &
      &                 //trim( relaxation )

    select case(trim(relaxation))
    case( 'bgk' )
      select case( trim(layout) )
      case default
        compute => mus_nernstPlanck_advRel_explicit
      end select   
    case default
      write(logUnit(1),*) 'Relaxation '//trim(relaxation)//' is not supported!'
      call tem_abort()
    end select

  end subroutine mus_init_advRel_nernstPlanck
  ! ************************************************************************** !


end module mus_initNernstPlanck_module
