! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> author: Simon Zimny
!! author: Kartik Jain
!! This module contains the type definition(s) required in the scheme routines
!! In addition depend type and condition type for geometry increase routine
!! are defined. Compute kernel definition is also defined in this module
!!
?? include 'header/lbm_interfaceMacros.inc'
module mus_scheme_type_module

  ! include treelm modules
  use env_module,                only: rk
  use tem_tracking_module,       only: tem_tracking_type,        &
    &                                  tem_tracking_config_type, &
    &                                  tem_trackingControl_type
  use tem_varSys_module,         only: tem_varSys_type,          &
    &                                  tem_varSys_op_type
  use tem_variable_module,       only: tem_variable_type
  use tem_varMap_module,         only: tem_varMap_type,          &
    &                                  tem_possible_variable_type
  use tem_spacetime_fun_module,  only: tem_st_fun_linkedList_type
  use tem_construction_module,   only: tem_levelDesc_type

  ! include musubi modules
  use mus_bc_header_module,          only: glob_boundary_type
  use mus_field_module,              only: mus_field_type
  use mus_field_prop_module,         only: mus_field_prop_type
  use mus_pdf_module,                only: pdf_data_type
  use mus_scheme_layout_module,      only: mus_scheme_layout_type
  use mus_scheme_header_module,      only: mus_scheme_header_type
  use mus_derVarPos_type_module,     only: mus_derVarPos_type
  use mus_param_module,              only: mus_param_type
  use mus_mixture_module,            only: mus_mixture_type
  use mus_source_var_module,         only: mus_source_type
  use mus_interpolate_header_module, only: mus_interpolation_type
  use mus_transport_var_module,      only: mus_transport_var_type
  use mus_nernstPlanck_module,       only: mus_nernstPlanck_type
  use mus_turbulence_module,         only: mus_turbulence_type
  use mus_auxField_module,           only: mus_auxFieldVar_type, &
    &                                      mus_proc_calcAuxField

  implicit none
  private

  public :: mus_scheme_type
  public :: kernel
  public :: array2D_type

  type array2D_type
    !! To allow Intel AVX SIMD streaming store instructions,
    !! the array must be aligned at 32 bytes
    real(kind=rk), allocatable, dimension(:,:) :: val
    !dir$ attributes align : 32 :: val
  end type array2D_type

  !> Datatype containing all information on the scheme.
  !!
  !! The mus_scheme_type contains of all information that are needed
  !! to run a simulation (including informations on the: fluid, boundary
  !! conditions, levelDescriptor, state vector, layout, diffusion info,
  !! tracking).
  type mus_scheme_type

    !> Interpolation description for each scheme to do its own interpolation
    type(mus_interpolation_type) :: intp

    !> Contains information for turbulence model
    type(mus_turbulence_type) :: turbulence

    !> contains mixture information for multispecies
    type(mus_mixture_type) :: mixture

    !. Contains information for nernst-planck
    type(mus_nernstPlanck_type) :: nernstPlanck

    !> number of fields in the current scheme
    integer :: nFields = 0
    !> array of field type for each field
    type(mus_field_type), allocatable :: field(:)

    !> array of boundary types contains elems of each boundary
    type(glob_boundary_type), allocatable :: globBC(:)

    !> global source applied to all fields
    type(mus_source_type) :: globSrc

    !> possible source variables depends on scheme kind
    type(tem_possible_variable_type) :: poss_srcVar

    !> transport variables
    type(mus_transport_var_type) :: transVar

    !> possible transport variables depends on scheme kind
    !! This variables might be used in compute kernel
    type(tem_possible_variable_type) :: poss_transVar

    !> identifier of the scheme
    type(mus_scheme_header_type) :: header

    type(tem_levelDesc_type), allocatable :: levelDesc(:)
    !> pdf_data_types for every level
    !! size: minLevel:maxLevel
    type(pdf_data_type), allocatable :: pdf(:)

    !> Data vector containing the pdf state
    !! allocated in routine: mus_construct
    !! size: minLevel:maxLevel
    type( array2D_type ), allocatable :: state(:)

    !> the scheme representation used in this scheme
    type(mus_scheme_layout_type) :: layout

    !> function pointer to compute kernel
    procedure( kernel ), pointer, nopass :: compute => null()

    !> Contains trackingControl, config and instances
    type( tem_tracking_type ) :: track

    !> Position of reduction transient variable in varSys
    type(tem_varMap_type) :: redTransVarMap

    !> store position of derived variable each field and total field
    !! in the global system
    type(mus_derVarPos_type), allocatable :: derVarPos(:)

    !> global variable system definition
    type(tem_varSys_type) :: varSys

    !> Variables defined in the lua file
    type(tem_variable_type), allocatable :: luaVar(:)

    !> state variable position in the global varSys
    type(tem_varMap_type) :: stateVarMap

    !> contains spacetime functions defined for lua variables
    type(tem_st_fun_linkedList_type) :: st_funList

    !> Used in mus_harvesting to check whether variables loaded from
    !! restart file has pdf variable
    logical :: readVarIsPdf

    !> stores auxField variable values and function pointer to compute
    !! auxiliary field
    !! Size: minlevel:maxLevel
    type(mus_auxFieldVar_type), allocatable :: auxField(:)

    !> Function pointer to evaluate auxilary variable
    procedure(mus_proc_calcAuxField), pointer, nopass :: calcAuxField => null()

  end type mus_scheme_type

  !> What does the kernel interface look like?
  !! Every kernel's argument list must correspond to this one
  abstract interface
?? copy :: compute_routineHeader( kernel )
      import :: rk, mus_field_prop_type, mus_scheme_layout_type,               &
        &       mus_scheme_type, tem_varSys_type, mus_param_type
?? copy :: compute_routineParams
    end subroutine kernel
  end interface

end module mus_scheme_type_module
! ****************************************************************************** !
