# Run Musubi with different number of processes and check the restart file, 
# if it is identical by using the checksum (md5sum)

executable=../../../build/debug/musubi

# delete existing restart folder
rm -rf restart/
string=''
counter=0

procs='1 2 3 4 5 6 7 8 9 10 11 12'

for nprocs in $procs;
do
  counter=$((counter+1))
  mkdir restart
  mpirun -np ${nprocs} ${executable}
  sumname=sum_${nprocs}

  echo 'Storing md5sum to ' $sumname
  md5sum restart/*.lsb > ${sumname}
  rm -rf restart

  if [ $counter -eq 1 ]; then
    echo 'setting reference MD5sum'
    firstsum=$sumname
  fi
done

counter=0
for nprocs in $procs;
do
  counter=$((counter+1))
  string="${firstsum} sum_${nprocs}  "

  if [ $counter -eq 1 ]; then
    echo 'reference md5sum'
  else
    echo  "Now testing difference between $string :"
    difference=`diff $string`
    if [ "X$difference" = "X" ]; then
      echo 'No difference found. OK!'
    else
      echo 'ERROR: Difference found:'
      echo ${difference}
    fi
  fi
done
echo 
echo 
echo "Done. "
