-- Use this file as template. Do not modify this file for running some testcases
-- Height of the cylinder
height =  0.41 --m
-- number of elements in height
nHeight = 32
-- length to height ratio
l_h = 5
-- number of elements in length
nLength = nHeight*l_h 
-- element size
dx = height/nHeight
-- length of the channel
length = nLength*dx
-- number of elements in bounding cube
--=number of elements in channel + inlet + outlet
nLength_bnd = nLength+2
-- level required to reach computed dx
level = math.ceil(math.log(nLength_bnd)/math.log(2))
-- length of the bounding cube
length_bnd = (2^level)*dx

-- smallest possible element size
dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half

-- Cylinder information
useObstacle = true
-- calculate qValues
qVal = true 
-- radius of the cylinder
radius = 0.05
-- Diameter of the cylinder
Dia = radius*2.0
-- position of cylinder
cyl_pos = 0.2 --m
-- Offset of cylinder from channel inlet from current position of 0.2m
offset_cyl = 0--height

-- length of refinement patch
refineLength = height
refinePatch = false 
-- level of refinement patch
if refinePatch then
  refineLevel = level+1
else
  refineLevel = level
end

-- refine cylinder to specific level 
refineCyl = true
-- level of cylinder
if refineCyl then
  cylLevel = level+2
else
  cylLevel = level
end

-- directory to write mesh
folder = 'mesh/'

NOdebug = {debugMode = true}
-- How detailed should the output be?
-- The higher the level, the more output you'll get from seeder.
logging = { level = 5 }

timing_file = 'sdr_timing.res'

-- We require elements neighboring boundaries to be refined down to the level
-- of the boundaries themselves. However, this is checked on all levels, and
-- results in some kind of smoothing of the refinements towards the actual
-- boundaries.
-- If this is not desired, this can be deactivated by setting smoothbounds to
-- false.
-- WARNING: If this is set to false, you might end up with elements that only
--          have partial boundaries. To avoid this, you need to configure an
--          appropriate refinement box around the geometry, with the same level
--          as the boundary itself.
-- Default is to use smoothening towards the boundaries (true).
smoothbounds = true

-- To smooth between levels to restrict level jump in the domain to 1
-- Default is set to true
smoothlevels = true

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

-- A minimum level, by which all parts in the computational domain should at
-- least be resolved with. Default is 0.
minlevel = level

-- *********************** Table of spatial objects *********************** --
-- Each spatial object is defined by an attribute and some geometric entity
-- attached to this attribute. Attributes might be defined multiple times.
-- Attributes are described by a kind (boundary, seed or refinement), a level
-- and maybe further kind specific values, like a label for the boundary.
-- Geometric objects might by right now:
-- - canoND (point, line, plane or box)
-- - STL
-- - Sphere
-- - Cylinder
--
-- Periodic boundaries are special, spatial objects of this kind can only make
-- use of geometric objects of the kind 'periodic'.
spatial_object = {
-- Seed point
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { dx, height*0.5, zpos },
        }
    }
  },
-- North boundary  
  {
    attribute = {
      kind = 'boundary',
      label = 'north',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -dx/2,height+dx_eps,-dx/2 },
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
-- South boundary  
  {
    attribute = {
      kind = 'boundary',
      label = 'south',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx_eps,-dx/2.0},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
-- East boundary: outlet  
  {
    attribute = {
      kind = 'boundary',
      label = 'east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
-- West boundary: Inlet  
  {
    attribute = {
      kind = 'boundary',
      label = 'west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
-- Periodic boundary  
  {  
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx_eps, -dx_eps, dx+dx_eps},
          vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,height+2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {length+2*dx_eps,0.0,0.0}}
        } --- plane2        
      }  
    }
  }
}

-- use obstacle 
if useObstacle then
  table.insert(spatial_object,
    {
      attribute = { 
        kind = 'boundary', 
        label = 'obst', 
        level = cylLevel,
        calc_dist = qVal, 
        flood_diagonal = true,
        -- level and radius for distance refinement 
        distance_refine = {
          {
            radius = 0.05,
            level_offset = 0 
          },
          {
            radius = 0.1,
            level_offset = -1
          },
        }
      },
      geometry = {
        kind = 'stl', 
        object = { 
          filename = 'cylinder.stl'
        }
      },
      transformation = {
        deformation =  {radius,radius,radius },
        translation =  {offset_cyl+cyl_pos, 0.2, 0. }
      }
    }
  )
end

-- Refinement patch  
if refinePatch then
  table.insert(spatial_object,
    {
      attribute = {
        kind = 'refinement',
        level = refineLevel
      },
      geometry = {
        kind = 'canoND',
        object = {
          origin = { offset_cyl+cyl_pos/2.0,height/4.0,-dx },
          vec = {{refineLength,0.0,0.0},
                 {0.0,height/2.0,0.0},
                 {0.0,0.0,height}}
          }
      }
    }
  )
end
