-- Musubi configuration file for passive scalar verification.

require "common"

-- Simulation name
simulation_name = 'memoryTest'
mesh = { predefined='cube', 
         origin = {0.,0.,0.}, 
         length = L_phy, 
         refinementLevel = ref_level }
printRuntimeInfo = true
-- Debug options
--debug = { debugMode = true,  -- activate global debug modus
--          debugFiles = true, -- open the debugFiles for each process dbgOut0000**.out
--          dumpDependencies = true -- write the dependencies between levels to disk
--          }

-- Interpolation method
--interpolation_method = 'average'                   

-- Time step settigs
tmax           =  nIter     -- total iteration number
time = {useIterations = true,
        min = 1, max = tmax, interval = checkInter}

scheme = {
  {
  -- simulation kind
  identify = { label = 'species', kind = 'passive_scalar', 
               relaxation = 'bgk_noFluid', layout = 'flekkoy' },

  -- define the underlying velocity to be 0 for pure diffusion verification
  depend = { variable={'velocity', 3, {kind='const', const={0.0, 0.0, 0.0}} }, usescheme='fluid'},
              
  field = {
    -- field 1 = species 1
    { label = 'spc1',
      species = { 
                  diff_coeff = {D}
      },
      initial_condition = { density = 0.0,
                            velocityX = 0.0,
                            velocityY = 0.0,
                            velocityZ = 0.0 },
    }
  -- close the field table
  }
 -- close the current scheme
 }
 -- close the scheme table
}
