require "seeder"
-- Musubi configuration file. 
-- This is a LUA script.

-- Local refinement settings
--interpolation_method = 'copyfirst'
interpolation_method = 'eqneq'
                     
debug = {
  debugMode = true, 
  debugFiles = true, 
  verbosity = 900, 
  dumpAuxLists = true,
  dumpDependencies = true,
  dumpState = true}

-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information
-- Time step settigs
tmax           = 2   
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax }
io_buffer_size = 1

originX = length*0. 
originY = length*0.--2  
originZ = length*0.--2 
halfwidth = length/5.
amplitude = 0.01
background = 1.0

function ic_1Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_3Dgauss_pulse(x, y, z)
  return background +amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2+( z - originZ )^2))
end
scheme = {
{
-- Initial condition 
initial_condition = { density = ic_3Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 },

fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 },
layout = 'd3q19',
label='debug_restart',

 -- Boundary conditions
oundary_condition = {  
 { label = 'periodic_Z',
    kind = 'periodic' }
 },

-- Output settings
output = { active = true, -- VTK output activated?
  folder = 'output/',      -- Output location
  vtk = true,              -- VTK output activated?
  dumpGhosts = true, 
  dumpHalos = true,
  time = {min = 0, max = -1, interval = tmax/10} 
  }            

-- Tracking              
, racking = {
--   { label = 'probe_density', 
--   variable = {{'velocity'},{'density'}}, 
-- --  reduction = {'sum','average'}, 
--   folder = 'tracking/',
-- --  shape = {{object = 'line',line= { origin = {0.,0.,0.}, direction = {1.0,0.,0.}, segments = 300}}},
--   shape = {{object = 'point',point= {{0.,0.,0.}}}},
-- --  shape = {{object = 'all'}},
--   time = {min = 0, max = 10, interval = 1}, 
--   format = 'ascii' }
  { label = 'line', 
  variable = {{'density'}, {'velocity'}}, 
  folder = 'tracking/',
   shape = {{object = 'line', 
             plane = {pos = {.0,-5.0,-5.0} , vecA = {.0,10.0,0.}, 
                      vecB = {.0,.0,10.}, segments1 = 100,
                      segments2 = 100},
             line = { origin = {.0,-5.0,-2.5} , direction = {.0,10.0,0.}, 
                      segments = 100}}},
  time = {min = 0, max = 10, interval = 1}, 
  format = 'ascii' } 
  ,
  { label = 'hvs_plane', 
  variable = {{'density'}, {'velocity'}}, 
  folder = 'tracking/',
   shape = {{object = 'plane', 
             plane = {pos = {-5.0,-5.0,.0} , vecA = {.0,10.0,0.}, 
                      vecB = {10.0,.0,0.}, segments1 = 100,
                      segments2 = 100}}},
--   shape = {{object = 'line', 
--             line = { origin = {.0,-5.0,-2.5} , direction = {.0,10.0,0.}, 
--                      segments = 100}}},
  time = {min = 0, max = 10, interval = 1}, 
  format = 'harvester' } 
  }
} -- close the scheme
} -- close the scheme table
-- Restart settings
estart = { ead = 'restart/gaussian_header_0002.000E+000000.lua',
            write = 'restart/',
            time = { min = -1, max = tmax, interval = 1}}
