level = 7
refinementLevel = 1
--interpolation_method = 'average'
--interpolation_method = 'quadraticCompact'
interpolation_method = 'linear'

refOmega = 1.95
refLevel = 5
length = 1.0
heightElem_refLevel = 6
refDx = length/math.pow(2,refLevel)
refHeight = heightElem_refLevel*refDx
m = 2^(refLevel - level)
omega = 1./(1/m*(1/refOmega -0.5)+0.5)
maxLevel = level+refinementLevel
height = refHeight
dx     = length/math.pow(2,level)
dxDash = 0.001*dx
nElemsMax = 2^maxLevel
if refinementLevel == 0 then
  label = 'reference'
else
  label = interpolation_method
end



tMax = nElemsMax*100

print ("Reference Level   " .. refLevel)
print ("Coarsening Factor " .. m)
print ("Current level     " .. level)
print ("Current omega     " .. omega)
print ("Channel height    " .. refHeight)
print ("MaxElems          " .. nElemsMax)
if level < refLevel then
  error(' level is smaller than reference level'..refLevel )
end



