-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'Gausspulse'
--mesh = 'testsuite/physics/lidcavity/mesh/'
mesh = { predefined='cube', 
         origin = {0.,0.,0.}, 
         length = 10., 
         refinementLevel = 4 }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   

-- Time step settings
tmax           =  10     -- total iteration number
check_interval =  1   -- iteration check interval


-- schemes used

-- scheme 1
scheme = {
{

label = 'scheme1',
layout = 'predefined_d3q19',

-- Fluid properties
fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 },

-- Initial condition 
initial_condition = { 
     density =  {
       predefined='gausspulse', 
       center={5.0,5.0, 5.0}, 
       halfwidth=1., 
       amplitude=1.20, 
       background=1.000}, 
     velocityX = 0.0,
     velocityY = 0.0,
     velocityZ = 0.0 }

},

-- scheme 2
{
label = 'scheme2',
layout = 'predefined_d3q19',
-- Fluid properties
fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 },

-- Initial condition 
initial_condition = { 
     density =  {
       predefined='gausspulse', 
       center={5.0,5.0, 5.0}, 
       halfwidth=1., 
       amplitude=1.20, 
       background=1.000}, 
     velocityX = 0.0,
     velocityY = 0.0,
     velocityZ = 0.0 }

}
}

-- Output settings
output = { active = true, -- VTK output activated?
  folder = 'output/',     -- Output location
  vtk = true,             -- VTK output activated?
  shearstress = false,    -- Shear Stress Tensor output?
  wss = false,            -- Wall Shear Stress output?
  interval = 1,     -- output interval 
  tmin = 0,               -- first iteration to output
  tmax = 10 }             -- last iteration to output

 -- Tracking              
  tracking = {
   { label = 'probe_press', 
     variables = {'density'}, 
     appendScheme = 1,
     type='point', point ={3.0,0.0,0.0} 
   },
   { label = 'probe_press', 
     variables = {'density'}, 
     appendScheme = 2,
     type='point', point ={3.0,0.0,0.0} 
   },

 { label = 'plane', 
  variables = {'state'}, -- state (=pdfs), pressure, density etc
  type='plane', plane ={ 
     origin = {0.,0.,32.}, 
     direction1 = {64.,0.,0.}, 
     direction2 = { 0.,64., 0.}, 
     segments1=300, 
     segments2=300, 
     distribution='equal'}, 
  format='harvester', folder='tracking/', 
  interval = 1, tmin = 0, tmax = 800 } 

  }


--debug = { debugMode = true, debugFiles = true,
--          debugMesh = './debug/mesh_', debugStates = { 
--  write = {
--    folder    = './debug/',    -- the folder the restart files are written to
--    interval  = 1,           -- dump restart file interval
--    tmin      = 1,           -- first timestep to output
--    tmax      = tmax+1       -- last timestep to output
--    }
-- }} 


-- Restart settings
restart = {
  -- If this table is available it will read the restart file
  -- given below.
--  read =  {
--    folder    = 'restart/', -- folder of the restart file
--    file_name = 'lastHeader.lua'                       -- the restart file to read
--  },
  -- If this table is available it will write a restart file
  -- with the specified options.
  write = {
    folder    = 'restart/', -- the folder the restart files are written to
    interval  = 1,                                     -- dump restart file interval
    tmin      = tmax,                                     -- first timestep to output
    tmax      = tmax                                     -- last timestep to output
  }
}
