#!/bin/bash
#PBS -N mus_cray
#PBS -A 12914
#PBS -l mppwidth=32
#PBS -l mppnppn=32
#PBS -l walltime=02:00:00
  
# Change to the direcotry that the job was submitted from
#cd $PBS_O_WORKDIR

export cpat='isend_irecv'

# Launch the parallel job to the allocated compute nodes
for level in 2 3 4 5 6 7 8; do
  for nproc in 16 8 4 2 1; do
  export level
  export nprocs=$nproc
  mpirun -np $nproc ../../../../build/musubi
  mv dbgOut0000000.out dbg_${level}_${nproc}.out
  rm dbgOut*.out
done
done
