level = tonumber(os.getenv("LEVEL"))
if level == nil then
  level = 7
end

Re         = 25
tmax       = 512
relaxation = 'bgk'
layout     = 'd3q19'

simulation_name = 'cube'
scaling         = 'diffusive'
control_routine = 'fast'
logging = { level = 5 }
printRuntimeInfo = false
mainPDF = true
block = 576
-- null_device = "/dev/null"

-- some constant parameters
twoPi = 2.0 * math.pi
length = twoPi
dx     = length / (2^level)
mesh = {
  predefined = 'cube',
  origin = {0, 0, 0},
  length = length,
  refinementLevel = level,
}
---------------------------------------------------------------------
-- Simulation setup

u0      = 1.0
rho0LB  = 1.0
rhoPhy  = 1.0
nuPhy   = 1.0 / Re
viscPhy = nuPhy * rhoPhy

omega = 1.8
nuLB  = ( 2.0/omega - 1.0 ) / 6.0
dt  = nuLB / nuPhy * dx * dx
uLB = u0 * dt / dx
tEnd = tmax * dt

-- origin is the center of first element
cs2 = 1./3.
p0 = rho0LB / rhoPhy * dx^2 / dt^2 * cs2
p0 = 0

kx = twoPi / length -- wave number in x direction
ky = twoPi / length -- wave number in y direction
tD = 1.0 / nuPhy / (kx^2+ky^2) -- rate of decay coefficient

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax },
  }
}

physics = { dt = dt, rho0 = rhoPhy }

scheme = {
  identify = {
    label = relaxation.."_"..layout.."_b"..block,
    kind = 'lbm',
    layout = layout,
    relaxation = relaxation,
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },

  initial_condition = {
    pressure  = {predefined = 'tgv_p' },
    velocityX = {predefined = 'tgv_ux'},
    velocityY = {predefined = 'tgv_uy'},
    velocityZ = 0.0,
    Sxx = {predefined = 'tgv_sxx'},
    Syy = {predefined = 'tgv_syy'},
    Szz = 0.0,
    Sxy = 0.0,
    Syz = 0,
    Sxz = 0,
  },

  racking = {
    {
      label = 'total_density',
      variable = { 'density'  },
      folder = 'tracking/',
      shape = { kind = 'global', },
      reduction = { 'sum' },
      output = { format = 'ascii' },
      time_control = {
        min = {iter=tmax}, max = {iter=tmax}, interval = tEnd / 10,
      },
    },
  },

} -- scheme table
