----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'channel'
mesh = 'mesh/' -- Mesh information
-- Time step settigs
tmax           =  1000     -- total iteration number
sim_control = {
  time_control = { max = { iter = tmax } }
} 

interpolation_method = 'linear'                     
rho0 = 1.
cs2 = 1./3.
p0 = rho0*cs2
fluid = { omega = 1.891, rho0 = 1.0 }

-- Initial condition 
initial_condition = { pressure = p0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

label='default'
-- Boundary conditions
boundary_condition = {  
{ label = 'west', 
  kind = 'inlet_ubb', 
  velocityX = { predefined = 'combined',
                temporal= {predefined='smooth', min_factor = 0.0, max_factor=0.08, from_time=0, to_time=5000}, 
                spatial = {predefined='parabol', 
                          shape = { kind = 'canoND', object = {center={-8.0,0.0,0.0},
                                                               vec = { {0.0,1.0,0.0}, {0.0,0.0,1.0} } }
                                  }
                          }         
	      },
   velocityY = 0.0, velocityZ = 0.0},
{ label = 'east',
   kind = 'outlet_expol', pressure = p0}, 
{ label = 'north', 
   kind = 'wall' },
{ label = 'south', 
   kind = 'wall' },
{ label = 'top', 
   kind = 'wall' },
{ label = 'bottom', 
   kind = 'wall' }
}

