require('S834_definition')


-- convert two points into plane table
function points2plane( p1x, p1y, p2x, p2y, extrude_len, rotation, scale )
  -- this point
  point1_x = scale*(   rotation[1][1] * p1x + rotation[1][2] * p1y )
  point1_y = scale*(   rotation[2][1] * p1x + rotation[2][2] * p1y )
  -- next point
  point2_x = scale*(   rotation[1][1] * p2x + rotation[1][2] * p2y )
  point2_y = scale*(   rotation[2][1] * p2x + rotation[2][2] * p2y )
  -- table.insert( plane_table,
  return {
    origin = { point1_x, point1_y, -extrude_len },
    vec = {
      { point2_x - point1_x, point2_y - point1_y, 0.0 },
      { 0.0, 0.0, extrude_len*2.0 },
    },
  }
end

level = 7
airfoil_level = level+1
start_x = -1.0
start_y = start_x
start_z = start_x
bounding_origin = { start_x, start_y, start_z }
bounding_length = 3.0
dx = bounding_length / (2^level)
dx_airfoil = bounding_length / (2^airfoil_level)
eps = bounding_length / (2^20)
extrude_len = dx*6
seed_x = start_x / 2
seed_y = 0
seed_z = dx / 2
top_y = 0.5
bottom_y = - top_y
inlet_x = start_x + dx/2
inlet_length = top_y - bottom_y
outlet_x = start_x + bounding_length - dx/2
outlet_length = inlet_length

-- Simulation settings, cord length of the airfoil, angle of attack
-- spatial order of the scheme, and level of the mesh
-- the spatial range is x:[0,1], y[-0.1,0.1]
airfoil_length = 1.0
angle_of_attack = math.rad(12.7)
-- angle_of_attack = 0
-- spatial_order = 8
folder = 'mesh/'
mesh   = folder


-- ... the scaling and rotation of the profile
scale = airfoil_length
rotation = {
  { math.cos(angle_of_attack), math.sin(angle_of_attack)},
  {-math.sin(angle_of_attack), math.cos(angle_of_attack)}
}

airfoil = {}

nPoints = #S834_vertex
-- print('This table has '..nPoints..' verteces')

for i = 1, nPoints-1 do
  table.insert(
    airfoil,
    points2plane( S834_vertex[i][1],   S834_vertex[i][2],
                  S834_vertex[i+1][1], S834_vertex[i+1][2],
                  extrude_len, rotation, scale )
  )
  -- print('origin: ')
  -- for k,v in pairs(profile[i].origin) do print(k,v) end
  -- print('vec1: ')
  -- for k,v in pairs(profile[i].vec[1]) do print(k,v) end
  -- print('vec2: ')
  -- for k,v in pairs(profile[i].vec[2]) do print(k,v) end
end

-- for last point, it need the first point
table.insert(
  airfoil,
  points2plane( S834_vertex[nPoints][1],   S834_vertex[nPoints][2],
                S834_vertex[1][1],         S834_vertex[1][2],
                extrude_len, rotation, scale )
)
-- print('Profile table has '..#profile..' planes')
