require "common"
folder = 'mesh/'
logging = {level=10}
NOdebug = {debugMode = true, debugMesh = 'debug/'}
bounding_cube = {
  origin = bounding_origin,
  length = bounding_length,
}

minlevel = level
smooth_bounds = false
spatial_object = {
  {
    attribute = {
      kind = 'seed',
      label= 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { seed_x, seed_y, seed_z },
        -- vec = { l_ch-dx, 0.0,0.0}
      }
    }
  },

  { -- Defining Z planes
    attribute = {
      kind  = 'boundary', -- or seed, refinement
      label = 'z',   -- some label to identify the boundary condition
      level = level,
      calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        { -- -z plane
          origin = { start_x, start_y, -extrude_len/2.0+2*eps },
          vec = {
            { bounding_length+2*dx, 0, 0 },
            { 0, bounding_length+2*dx, 0 },
          },
        },
        { -- +z plane
          origin = { start_x, start_y, extrude_len/2.0+eps },
          vec = {
            { bounding_length+2*dx, 0, 0 },
            { 0, bounding_length+2*dx, 0 },
          },
        },
      },
    }
  }, -- Z planes


  {
    -- Defining a airfoil
    attribute = {
      kind  = 'boundary', -- or seed, refinement
      label = 'airfoil',   -- some label to identify the boundary condition
      level = airfoil_level,
      calc_dist = false,
      flood_diagonal = false,
      distance_refine = {
        {
          radius = 0.05,
          level_offset = 0
        },
        {
          radius = 0.1,
          level_offset = -1
        },
        {
          radius = 0.2,
          level_offset = -2
        },
      }
    },
    geometry = {
      kind = 'canoND',
      object = airfoil,
    }
  },

  { -- Defining top and bottom planes
    attribute = {
      kind  = 'boundary', -- or seed, refinement
      label = 'top',   -- some label to identify the boundary condition
      level = level,
      calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        { -- top plane
          origin = { start_x, top_y, -extrude_len/2-eps },
          vec = {
            { bounding_length+2*dx, 0, 0 },
            { 0, 0, extrude_len+2*dx },
          },
        },
        { -- bottom plane
          origin = { start_x, bottom_y, -extrude_len/2-eps },
          vec = {
            { bounding_length+2*dx, 0, 0 },
            { 0, 0, extrude_len+dx*2 },
          },
        },
      },
    }
  }, -- top and bottom planes
  { -- Inlet
    attribute = {
      kind = 'boundary',
      label = 'inlet',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { inlet_x, bottom_y, -extrude_len/2.0-eps },
        vec = {
          { 0.0, inlet_length, 0 },
          { 0.0,          0.0, extrude_len+dx*2 },
        },
      },
    },
  },
  { -- Outnlet
    attribute = {
      kind = 'boundary',
      label = 'outlet',
      level = level,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { outlet_x, bottom_y, -extrude_len/2-eps },
        vec = {
          { 0.0, outlet_length, 0 },
          { 0.0,           0.0, extrude_len+dx*2 },
        },
      },
    },
  },
}
