-- Musubi configuration file. 

require "common" 

folderRead = 'restart_read/'
folderWrite = 'restart/'

--dt_loc = getdtFromVel( dx, u_in_phy, u_in_L )
--dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
--dt = getdtFromVel( {dx = dx, u_p = u_in_phy, u_l = u_in_L } )
--omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

if bc_type == 'moments' then
  inletBC = 'moments_vel'
  --inletBC = 'moments_press'
  outletBC = 'moments_press'
  wallBC = 'moments_wall'
  --wallBC = 'wall'
end
if bc_type == 'BounceBack' then
  inletBC = 'inlet_ubb'
  --inletBC = 'outlet_expol'
  outletBC = 'outlet_expol'
  wallBC = 'wall'
end

-- Simulation name
simulation_name = 'channel2D'
--mesh = 'mesh_sph/' -- Mesh information
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
control_routine = 'fast'
require_moments = true
-- Time step settigs
tmax_p = 1000 --s
tmax =  1000--tmax_p/dt    -- total iteration number
interval_p = tmax_p/10
interval = 1000
sim_control = {
  time_control = { 
    max = {sim=tmax_p,iter=tmax}, 
    interval = {sim=interval_p,iter=interval}
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true
  }
}

restart = {
      ead = 'restart/channel2D_lastHeader.lua',
      write = 'restart/',
      -- without timeControl table restart will be dumped at last timestep
      --time_control = { min = 0, max = tmax_p, interval = dt*1},
      --time_control = { min = 0, max = {sim=tmax_p,iter=tmax}, interval = {iter=interval}},
}


--balance = { active = false, dynamic = true, kind = 'levelwise',
--            time_control = { interval = {iter=3}, min = {iter=14}, max = {iter=tmax}}
--  }


--debug = { debugMode = true, debugFiles = true, debugNormal = true,
--          debugMesh = './debug/mesh_', debugStates = { 
--  write = {
--    folder    = './debug/',    -- the folder the restart files are written to
--    interval  = 1,           -- dump restart file interval
--    tmin      = 0,           -- first timestep to output
--    tmax      = tmax+1       -- last timestep to output
--    }
-- }} 


fluid = { 
        --omega_ramping = {predefined='smooth', min_factor = 0.5, 
        --                   max_factor=1.0, from_time=0, to_time=10000.0*dt}, 
           --kine_shear_viscosity = nu_phy,
           omega = omega,
           rho0 = rho0_p }

interpolation_method = 'linear'                     

originX_1 = length/2.0
originX_2 = 0.
originY = .0
originZ = .0
pulse_size = length/20.
halfwidth = pulse_size
amplitude = 0.0001
background = 1.0

function ic_1Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX_1 )^2)
  --return background+amplitude*math.exp(-0.5/(halfwidth^2)*( y - height/2.0 )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX_2 )^2+( y - originY )^2))
end

-- Initial condition 
initial_condition = { 
                      pressure = ref_press, 
                      --pressure = ic_1Dgauss_pulse, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {label='bgk',layout='d3q19', relaxation='bgk',
            kind = 'lbm_incomp'
            }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            
-- Boundary conditions
boundary_condition = {  
  {
    label = 'west', 
    --kind = 'wall',
    --kind = 'moments_press',
    kind = inletBC,
    --kind = 'moments_wall',
    pressure = press_inlet, 
    velocityX = u_inflow,
    velocityY = 0.0, velocityZ = 0.0
  },  
  {
    label = 'east',
    kind = outletBC,
    --pressure =  0.999*cs2 --ref_press-press_grad
    pressure = ref_press
  }, 
  {   
    label = 'north', 
    kind = wallBC,
   fac = 1.0 
  },
  {
    label = 'south', 
    kind = wallBC,
   fac = 1.0 
  },
  {   
    label = 'top', 
    kind = wallBC,
   fac = 1.0 
  },
  {
    label = 'bottom', 
    kind = wallBC,
   fac = 1.0 
  },
 }

variable = {
  --analytic solution
  { name='vel_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = u_inflow },
  { name='wss_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = wssA },
  { name='press_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = pressA },
    --error
  { name = 'diff_pressure', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'pressure_phy','press_an'}
    }
  },
  { name = 'diff_wss', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'wss_phy','wss_an'},
    }
  },
  { name = 'diff_vel', 
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag_phy','vel_an'}
    }
 },
}--variable

-- Tracking              
tracking = {
{
  label = 'probe', 
  folder = 'tracking/',
 variable = {'pressure_phy','velocity_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5-offset,height*0.5-offset} } },
 time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
  format = 'ascii'      
},
{
  label = 'pressInlet', 
  folder = 'tracking/',
 variable = {'pressure_phy'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{
  label = 'pressOutlet', 
  folder = 'tracking/',
 variable = {'pressure_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{
  label = 'press_line', 
  folder = 'tracking/',
 variable = {'pressure_phy','press_an', 'diff_pressure'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,height*0.5-offset,height*0.5-offset},
                                     vec = {length,0.0,0.0},
                                     segments = nLength+2} },
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{ label = 'press_l2norm',
  variable = {
    'diff_pressure', 
      'press_an',
              },
 shape = {kind = 'canoND', object = {origin ={0.0,height*0.5-offset,height*0.5-offset},
                                     vec = {length,0.0,0.0},
                                     segments = nLength+2} },
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',
},
{
  label = 'velProfile', 
  folder = 'tracking/',
  variable = {'vel_mag_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2}}},
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{ label = 'convergence',
  variable = {'vel_mag_phy'}, 
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2}} },
  time_control = {min = 0, max = tmax_p, interval = 10*dt},
  format='convergence',
  reduction = 'average',
  convergence = {norm='average', nvals = 50, absolute = true,
  condition = { threshold = 1.e-12, operator = '<=' }}
},
{ label = 'wss_spatial',
  variable = { 'wss_phy', 
               'wss_an', 
              'diff_wss'
             },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  folder = './tracking/',
  format = 'asciiSpatial',
},

{ label = 'wss_l2norm',
  variable = {
    'diff_wss',
    'wss_an'
              },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',
},
{ label = 'vel_spatial',
  variable = {
    'vel_mag_phy',
    'vel_an',
    'diff_vel'
              },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  folder = './tracking/',
  format = 'asciiSpatial',
},
{ label = 'vel_l2norm',
  variable = {
    'diff_vel',
    'vel_an'
              },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',
}
}
