usePeriodic = true
-- simulation domain settings
length = 10.0
level =  7  
refinementLevel = 0
patchsize = 0.35*length
patchsize2 = 0.60*length
verbose = false

minlevel  = level
maxLevel = level+refinementLevel
dx     = length/(2^level)
dxDash = 0.001*dx
nElemsMax = 2^maxLevel
folder = 'mesh/'
bounding_cube = {
  origin = {
    -length*0.5,-length*0.5,-length*0.5
  },
  length = length
}

startBox = -length
lengthBox = 2*length

spatial_object = {
  {
    attribute = {
      kind = 'refinement',
      level = level+1*refinementLevel,
      label='box1'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          -patchsize2*0.5, -patchsize2*0.5, startBox
        },
        vec = {
          { patchsize2, 0., 0.},
          { 0., patchsize2, 0.},
          { 0., 0., lengthBox }
        }
      }
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = level+2*refinementLevel,
      label='box2'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {
          -patchsize*0.5, -patchsize*0.5, startBox
        },
        length = {
          patchsize, patchsize, lengthBox
        },
        vec = {
          { patchsize, 0., 0. },
          { 0., patchsize, 0. },
          { 0., 0., lengthBox }
        }
      }
    }
  },
  { attribute = { kind = 'seed', },
    geometry = { 
      kind = 'canoND',
      object = { origin = { 0.0, 0.0, dx*0.5 },
      }
    } -- geometry
  }, -- seed
  {  -- helper wall 
    attribute = {
      kind = 'boundary',
      label='northwest'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5+dx, length*0.5-dx, -length*0.5},
        vec = {{0.0, dxDash, 0.},
              {0.,0.0, length}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length*0.5, -length*0.5, -length*0.5},
        vec = {{0.0, length, 0.},
              {0.,0.0, length}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5, -length*0.5, -length*0.5},
        vec = {{0.0, length, 0.},
              {0.,0.0, length}}
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='north'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5, length*0.5, -length*0.5},
        vec = {{length, 0.0, 0.},
              {0.,0.0, length}}
      }
    }
  },  
  {
    attribute = {
      kind = 'boundary',
      label='south'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5,-length*0.5, -length*0.5},
        vec = {{length, 0.0, 0.},
              {0.,0.0, length}}
      }
    }
  }
}

if usePeriodic == true then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { -length/2, -length/2, -dxDash},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { -length/2,  -length/2, dxDash +dx},
          vec = { { 0., length, 0.0, 0.0},
                  { length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
end

