csLB = 1./math.sqrt(3.)
csPhys = 300.
nuPhys = 1.*10.^-3

level = 4
refine = 1
maxlevel = level + refine
length = 0.01
originX = -length*0.5
originY = -length*0.5
originZ = -length*0.5

dxPhys = length/2.^level
dxmax = length/2.0^maxlevel
dtPhys = csLB/csPhys*dxPhys

pulse_size = length/20.

channel_length = length
channel_height = channel_length/2.


-- Do not change these values. 
-- They are taken as a base to calculate the position of the periodic plane
dx = dxPhys
dxdash = 0.0001*dx

nuLB = nuPhys/dxPhys^2*dtPhys
dtLB = 1
global_omega = dtLB/(nuLB/csLB^2 + dtLB*0.5)
tmax = 30 --2^maxlevel

print("Parameter File ")
print(" Shear visc.:   "..nuPhys)
print(" cs Phys ref:   "..csPhys)
print(" Basic Level:   "..level)
print(" Basic Level:   "..level)
print("          dx:   "..dx)
print("  Max. Level:   "..level)
print("       refdx:   "..dxPhys)
print("          dt:   "..dtPhys)
print("                ")
print("   cs LB ref:   "..csLB)
print("   nu LB ref:   "..nuLB)
print(" Resulting om   "..global_omega)


