comment = 'cylinder'
folder = 'mesh/'

minlevel = 1
maxlevel = 8
BBL = 0.1

spatial_object = {
  { -- cylinder
    attribute = { kind = 'boundary', label = 'wall',
                  level = maxlevel, calc_dist = false,
    },
    geometry = {
      kind = 'stl', object = { filename = 'stls/cylinder.stl', },
    },
    transformation = {
      deformation = 0.01,}
  },
  { -- inlet
    attribute = { kind = 'boundary', label = 'inlet',
                  level = maxlevel, calc_dist = false,
    },
    geometry = {
      kind = 'stl', object = { filename = 'stls/inlet.stl', },
    },
    transformation = {
      deformation = 0.01,}
  },
  { -- outlet
    attribute = { kind = 'boundary', label = 'outlet',
                  level = maxlevel, calc_dist = false,
    },
    geometry = {
      kind = 'stl', object = { filename = 'stls/outlet.stl', },
    },
    transformation = {
      deformation = 0.01,}
  },
  { -- refinement
    attribute = { kind = 'refinement', label = 'outlet',
                  level = maxlevel, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -1.0, -1.0, -4.0 },
        vec = { {2.0,0,0,0},
                {0.0,2.0,0.0},
                {0.0,0.0,8.0},
        }
      }
    },
    transformation = {
      deformation = 0.01,}
  },
  { -- seed
    attribute = { kind = 'seed',
                  level = maxlevel, calc_dist = false,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 0.0, 0, 0 },
      }
    }
  },
}

bounding_cube = {
  origin = {-0.02, -0.02, -.05},
  length = 0.1}

---- refinebox: three entries: origin, length and refinementlevel
--refinebox = {
--             {origin = {-1.0, -1.0, -4.0},
--              length = {2.0, 2.0, 8.0},
--              refinementlevel = ref_level2
--	     } 
--}            
--
---- seed: position of seed 
--seed = { points = { {0.0, 0.0, 0.0 }
--                  }
--       }
--
