from subprocess import Popen, PIPE

plot  = []

# Simulation parameters
simfile = 'common.lua'
nozzle_inner_dia_X = float(Popen(['lua', '-e',"dofile '"+simfile+"'; print(string.format('%.2E',nozzle_inner_dia_X))"],stdout=PIPE).communicate()[0].decode('ascii'))

## Examples:
##http://matplotlib.github.com/api/pyplot_api.html#matplotlib.pyplot.plot
## HINT: startplot == False, can be used to generate multiple plots
show_plot = False
font_family= 'serif'
font_type= 'Times New Roman'
font_size = 14
set_majorgrid = True
# pressure
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_inner_p*.res'],
           col=[1,2], startplot = True, endplot = False, 
           label = 'Inside nozzle', ls = 'b-'))

plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_outlet_p*.res'],
           col=[1,2], startplot = False, endplot = True, format = 'png', 
           label = 'Outside nozzle',figname = 'pressureOverTime', 
           xlabel = 'time', ylabel = 'Normalized Pressure ($N/m^2$)',
           ls = 'r-'))


# velocity X
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_inner_p*.res',
                                   'tracking_bup/nozzle_2D_probe_nozzle_inner_p*.res'],
           col=[1,3], startplot = True, endplot = False, 
           label = 'Inside nozzle',
           ls = 'b-'))

plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_outlet_p*.res'],
           col=[1,3], startplot = False, endplot = True,  format = 'png',
           label = 'Outside nozzle',figname = 'velocityXOverTime', xlabel = 'time', ylabel = 'velocity X',
           ls = 'r-'))


# velocity Y
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_inner_p*.res'],
           col=[1,4], startplot = True, endplot = False, 
           label = 'Inside nozzle',
           ls = 'b-'))

plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_probe_nozzle_outlet_p*.res'],
           col=[1,4], startplot = False, endplot = True,  format = 'png',
           label = 'Outside nozzle',figname = 'velocityYOverTime', xlabel = 'time', ylabel = 'velocity Y',
           ls = 'r-'))


# Pressure inside nozzle
plot.append(dict(kind = 'axvline',val=nozzle_inner_dia_X, startplot = True, ls='b-', label='x='+str(nozzle_inner_dia_X)))
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_hline_p*_t*.res'],
           col=[1,4], startplot = False, endplot = True,  format = 'png',
           label = 'Pressure',figname = 'pressureInsideNozzle', 
           xlabel = 'x (m)', ylabel = 'Normalized Pressure ($N/m^2$)', ls = 'r-',
           xmin=-0.1, xmax=0.1))

# velocity X inside nozzle
plot.append(dict(kind = 'axvline',val=nozzle_inner_dia_X, startplot = True, ls='b-', label='x='+str(nozzle_inner_dia_X)))
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_hline_p*_t*.res'],
           col=[1,5], startplot = False, endplot = True,  format = 'png',
           label = 'Velocity X',figname = 'velocityXInsideNozzle', 
           xlabel = 'x (m)', ylabel = 'velocity X ($m/s$)', ls = 'r-',
           xmin=-0.1, xmax=0.1))

# velocity Y inside nozzle
plot.append(dict(kind = 'axvline',val=nozzle_inner_dia_X, startplot = True, ls='b-', label='x='+str(nozzle_inner_dia_X)))
plot.append(dict(kind = 'xy',data=['tracking/nozzle_2D_hline_p*_t*.res'],
           col=[1,6], startplot = False, endplot = True,  format = 'png',
           label = 'Velocity Y',figname = 'velocityYInsideNozzle', 
           xlabel = 'x (m)', ylabel = 'velocity Y ($m/s$)', ls = 'r-',
           xmin=-0.1, xmax=0.1))

