-- Use this file as template. Do not modify this file for running some testcases
require "common"
folder = 'mesh_channel/'--..subprefix

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-length_bnd*0.5,-length_bnd*0.5,-length_bnd*0.5},
               length = length_bnd}
ebug = {
  debugMode = true,
  debugMesh = './t0_'
}

minlevel = level

---- refinebox: three entries: origin, length and refinementlevel
--refinebox = {{origin = {-dx, -dx, -dx},
--            length = {length+4*dx, height+2*dx, 5.0*dx},
--            refinementlevel = level
--            }}               
if outflow then
  heightOuter = 2.*height
else
  heightOuter = height
end

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { length*0., 0., zpos },
        }
    }
  }
,
  {
    attribute = {
      kind = 'boundary',
      label = 'north'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -length*0.5-dx,0.5*heightOuter+dx_half,-0.5*length },
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,length}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dx,-0.5*heightOuter-dx/2.,-0.5*length},
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,length}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {0.5*length+dx/2.0,-heightOuter*0.5,-length*0.5},
        vec = {{0.0,heightOuter+2*dx,0.0},
               {0.0,0.0,length}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-0.5*length-dx/2.0,-heightOuter*0.5,-length*0.5},
        vec = {{0.0,heightOuter+2*dx,0.0},
               {0.0,0.0,length}}
        }
    }
  },
}
if usePeriodic then
  table.insert( spatial_object,
  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-length*0.5-2*dx,-height*0.5-dx,dx*1.5},
          vec = {{length+4*dx,0.0,0.0},
               {0.0,height+2*dx,0.0}}
        },
        plane2 = {
          origin = {-length*0.5-2*dx,-height*0.5-dx,-dx/2.0},
          vec = {{0.0,height+2*dx,0.0},
                 {length+4*dx,0.0,0.0}}
        }         
      }  
    }
  })
else
  table.insert( spatial_object,
 {
    attribute = {
      kind = 'boundary',
      label = 'top'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dx/2.0,-heightOuter*0.5-dx,0.5*heightOuter+dx*0.5},
        vec = {{length*3.,0.0, 0.},
               {0.0,3.*heightOuter, 0.}}
        }
    }
  })
  table.insert( spatial_object,
  {
    attribute = {
      kind = 'boundary',
      label = 'bottom'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dx/2.0,-heightOuter*0.5-dx,-0.5*heightOuter-0.5*dx},
        vec = {{length*2.,0.0, 0.},
               {0.0,2.*heightOuter, 0.}}
        }
    }
  })
end 


if obstacle then
  table.insert( spatial_object, 
  {
    -- Defining a domain boundary
    attribute = { kind = 'boundary', -- or seed, refinement
                  label = 'sphere',   -- some label to identify the boundary
                                     -- condition
                },
    geometry = {
      kind = 'sphere',
      object = {{
        radius = 0.1*height,
        origin = {-length*0.5+length*0.15,-height*0.05,0.0}
        }
      }  
    }  
  }
  )
end

if outflow then
  -- add a jet-like outflow
  table.insert( spatial_object, 
  {
    attribute = {
      kind = 'boundary',
      label = 'northOutflow'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -length*0.5-dx,0.5*height-dx_half,-0.5*length },
        vec = {{0.3*length+4*dx,0.0,0.0},
               {0.0,0.0,length}}
        }
    }
  })
  table.insert( spatial_object,
  {
    attribute = {
      kind = 'boundary',
      label = 'southOutflow'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dx,-0.5*height+dx/2.,-0.5*length},
        vec = {{0.3*length+4*dx,0.0,0.0},
               {0.0,0.0,length}}
        }
    }
  })
  if not usePeriodic then
  table.insert( spatial_object, 
  {
    attribute = {
      kind = 'boundary',
      label = 'topOutflow'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -length*0.5-dx,-length*0.5, 0.5*height-dx_half },
        vec = {{0.3*length+4*dx,0.0,0.0},
               {0.0,length,0.0}}
        }
    }
  })
  table.insert( spatial_object,
  {
    attribute = {
      kind = 'boundary',
      label = 'bottomOutflow'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dx,-length*0.5,-0.5*height+dx/2.},
        vec = {{0.3*length+4*dx,0.0,0.0},
               {0.0,length,0.0}}
        }
    }
  })
  end
end 

if outflow then
  --backplate
  table.insert( spatial_object, 
  {
    attribute = {
      kind = 'boundary',
      label = 'backplate'
    },
    geometry = {
      kind = 'canoND',
      object = {
        { origin = {-0.2*length+(2.9999)*dx,-length*0.5,0.5*height+dx/2.},
        vec = {{0.0,0.0,height}, {0.0,length,0.0}} },
        { origin = {-0.2*length+(2.9999)*dx,-length*0.5,-(0.5*height+dx/2.)},
        vec = {{0.0,0.0,-height}, {0.0,length,0.0}} },
        { origin = {-0.2*length+(2.9999)*dx,-(0.5*height+dx/2.),-length*0.5},
        vec = {{0.0,-height,0.0}, {0.0,0.0,length}} },
        { origin = {-0.2*length+(2.9999)*dx,0.5*height+dx/2.,-length*0.5},
        vec = {{0.0,height,0.0}, {0.0,0.0,length}} },
      }
    }
  })
end

