#
# This is the parameter file for the Shepherd.
# It is used for a parameter study on the error convergence of the TGV 
# in the laminar Regime Re=25.
# I extract the error in velocity and pressure and plot it over the refinement 
# level using plot_error.gpl
#
# path_to_lib is must 
path_to_lib = '/Network/Servers/grsacx01.grs.rwth-aachen.de/Volumes/home/hasert/apes/shepherd/lib'
apesdir = '/Network/Servers/grsacx01.grs.rwth-aachen.de/Volumes/home/hasert/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory

multilevel = True
multilevel = False

prod_dir = 'prod'
seeder_template = 'seeder.template'
run_preproc_exec = False
run_preproc_exec = True
path_to_preproc_exec = apesdir + 'seeder/build/seeder'
run_command_preproc = path_to_preproc_exec
######################################################################################
										     #
lua_template = 'musubi.template'
run_solver_exec = True
path_to_solver_exec = apesdir + 'musubi/build/musubi'
if multilevel:
  seeder_params = [ ["level",6], ["ref",1], ]
  lua_params = [
                ["intp", 'linear', 'quadratic'],
                ["rel", 'mrt'],
                ["scl", 'acoustic', 'diffusive'],
                ["model", 'lbm_incomp']
               ]
else:
  seeder_params = [ ["level",7], ["ref",0], ]
  lua_params = [
                ["intp", 'linear'],
                ["rel", 'mrt'],
                ["scl", 'acoustic', 'diffusive'],
                ["model", 'lbm_incomp']
               ]
run_command_solver = 'mpirun -np 8'

jobscript_template = 'quelea.template'
submit_job = False
sub_command = 'sbatch'
job_params = [  [ "NP_NODE", 3 ] ]
	
harvester_template = 'harvester.template'					     #
path_to_harvester_exec = apesdir + 'harvester/build/harvester'
