#
# This is the parameter file for the Shepherd.
# It is used for a parameter study on the error convergence of the TGV 
# in the laminar Regime Re=25.
# I extract the error in velocity and pressure and plot it over the refinement 
# level using plot_error.gpl
#
# path_to_lib is must 
path_to_lib = '/Network/Servers/grsacx01.grs.rwth-aachen.de/Volumes/home/hasert/repo/apes/shepherd/lib'        
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
scaling = 'acoustic'
Re = 1600
prod_dir = 'prodRe'+str(Re)+'_'+scaling
						             #
										     #
seeder_template = 'seeder.template'                                      #
run_preproc_exec = True 							     #
path_to_preproc_exec = '/Network/Servers/grsacx01.grs.rwth-aachen.de/Volumes/home/hasert/repo/apes/seeder/build/seeder'			     #
seeder_params = [
          ["level",5], 
          ["ref",0], 
          ]
run_command_preproc = path_to_preproc_exec               			     #
######################################################################################
										     #
lua_template = 'musubi.template'					     #
run_solver_exec = False
path_to_solver_exec = '../../../build/musubi'
lua_params = [
              ["Re", 
              Re ],
              ["scl", 
              scaling],
              ["om", 
              1.9],
              ["intp", 
              'quadratic'],
              ["rel", 
              'mrt']
             ]
run_command_solver = 'mpirun -np 4 ../../../build/musubi'

jobscript_template = 'quelea.template'
submit_job = True
sub_command = 'sbatch'
job_params = [  [ "NP_NODE",
                   1
                ]
             ]
	
#harvester_template = 'harvester.template'					     #
#path_to_harvester_exec = 'harvester'
