-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'pulse'

-- Mesh information
-- mesh = 'mesh/mesh_2M/'
mesh = { predefined = 'cube',
         origin = {0.0, 0.0, 0.0},
         length = 10.0,
         refinementLevel = 6
       }

fluid = { relaxation_scheme = 'BGK', omega = 1.8, rho0 = 1.0 }

-- Initial Case
initial_condition = { 
                     density = {predefined='gausspulse', 
                                center={5.0, 5.0, 5.0}, 
                                halfwidth=1.0, 
                                amplitude=1.20, 
                                background=1.000}, 
                    velocityX = 0.0,
                    velocityY = 0.0,
                    velocityZ = 0.0
                   }

interpolation_method = 'linear'                     

-- Time step settings
tmax           =  1000      -- total iteration number
--check_interval =  100      -- iteration check interval

-- Ramping settings  
ramping        = false

-- Output settings
--output = { active = false,
--           vtk = true,     -- VTK output activated?
--           interval = -1,        -- output interval 
--           tmin = 0,         -- first iteration to output
--           tmax = 0 } 
