show_plot = True
markers = ['k-s','r-','y-v','g-*','k-d','k-p']
plot  = []
font_size = 12
#figsize=[5,4]
set_majorgrid = True
font_family = 'serif'
font_type = 'Times New Roman'

# Velocity
plot.append(dict(kind = 'xy', 
            data=['tracking/*vel_spatial*.res'],
            col=[2,4],dtype='float',#npoints=25, 
            startplot = True, endplot = False,
            label = 'Simulation', ls = markers[0]))

plot.append(dict(kind = 'xy', 
            data=['tracking/*vel_spatial*.res'],
            col=[2,5],dtype='float', 
            startplot = False, endplot = True,
            xlabel = 'y (m)', 
            ylabel = 'Velocity (m/s)',
            label = 'Analytic', ls = markers[1], 
            legend=dict(loc=8),
            format = 'png', figname = 'Velocity_Profile'))

# pressure
plot.append(dict(kind = 'xy', 
            data=['tracking/*press_line*.res'],
            col=[1,4],dtype='float',#npoints=25,  
            startplot = True, endplot = False,
            label = 'Simulation', ls = markers[0])) 

plot.append(dict(kind = 'xy', 
            data=['tracking/*press_line*.res'],
            col=[1,5],dtype='float', 
            startplot = False, endplot = True,
            xlabel = 'x (m)', 
            ylabel = 'Pressure (Pa)',
            label = 'Analytic', ls = markers[1], 
            format = 'png', figname = 'Pressure_Profile'))

# Wall shear stress
plot.append(dict(kind = 'xy', 
            data=['tracking/*wss_spatial*.res'],
            col=[2,4],dtype='float', #npoints=25, 
            startplot = True, endplot = False,
            label = 'simulation', ls = markers[0])) 

plot.append(dict(kind = 'xy', 
            data=['tracking/*wss_spatial*.res'],
            col=[2,5],dtype='float', 
            startplot = False, endplot = True,
            xlabel = 'y (m)', 
            ylabel = 'WSS (Pa)',
            legend=dict(loc=9),
            label = 'Analytic', ls = markers[1], 
            format = 'png', figname = 'WSS_Profile'))

#velocity center line
plot.append(dict(kind = 'xy', 
            data=['tracking/*vel_centerLine*.res'],
            col=[1,4],dtype='float', #npoints=25, 
            startplot = True, endplot = True,
            xlabel = 'x (m)', 
            ylabel = 'Velocity (m/s)',
            label = 'simulation', ls = markers[0], 
            format = 'png', figname = 'VelLine_Profile' ))

# probe pressure
plot.append(dict(kind = 'xy', 
            data=['tracking/*probe*.res'],
            col=[1,2],dtype='float',
            startplot = True, endplot = True,
            ls = 'r-', xlabel = 'time (s)', ylabel = 'Pressure ($N/m^2$)',
            format='png', figname = 'pressureOverTime'))

# probe pressure
plot.append(dict(kind = 'xy', 
            data=['tracking/*probe*.res'],
            col=[1,3],dtype='float',
            startplot = True, endplot = True,
            ls = 'r-', xlabel = 'time (s)', ylabel = 'Velocity X ($m/s$)',
            format='png', figname = 'velocityOverTime'))

