-- Use this file as template. Do not modify this file for running some testcases
-- height of the channel
height =  0.41
nHeight = 16
dx = height/nHeight
-- refinement level
--refineLevel = 2
---- reference element size
--dx_ref = 0.05
---- element size
--dx = dx_ref/2^refineLevel 
-- channel length to height ratio
l_h = 5
---- number of elements in height
--nHeight = math.ceil(height/dx)
-- number of elements in length
nLength = nHeight*l_h 
-- length of the channel
length = nLength*dx

-- number of elements in bounding cube including
-- boundary elements (+2)
nLength_bnd = nLength+2
-- level required to achieve specified dx
level = math.ceil(math.log(nLength_bnd)/math.log(2))
-- length of the bounding cube
length_bnd = (2^level)*dx

dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half

qVal = false
folder = 'mesh/'--..subprefix

-- logging
logging = {level=10}
debug = {debugMode = true, debugFiles=true}

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

minlevel = level

--  spatial object is composed by the attribute and Geometry
spatial_object = {
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { dx, height*0.5, zpos },
        vec = {length-dx, 0.0,0.0}
        } --- object
    }
  },
  {
    attribute = {
      kind = 'boundary',  ---kind in attribute is seed/boundary/refinement/periodic
      label = 'north',     -- for north
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',    -- kind in geometry is canoND/sphere/stl 
      object = {
        origin = { -dx/2,height+dx_eps,-dx/2 },
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',   --- for south
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx_eps,-dx/2.0},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'west'     --- for west
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },

  {
    attribute = {
      kind = 'boundary',
      label = 'east'     --- for east
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },

  {
    attribute = {
      kind = 'periodic', --kind is periodic
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx_eps, -dx_eps, dx+dx_eps},
          vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,height+2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {length+2*dx_eps,0.0,0.0}}
        } --- plane2        
      }  
    }
  },
}


