-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'FlowCylinder'
mesh = 'mesh/'  -- Mesh information
-- Time step settings
tmax           =  11  -- total iteration number
check_interval =  1 -- iteration check interval

time = {useIterations = true,
        min = 1, max = tmax, interval = check_interval }

--Debug = { debugMode = true, debugFiles = true,
--        dumpTreeIDs=true, debugStates = { 
-- write = {
-- folder    = 'debug/',    -- the folder the restart files are written to
-- interval  = 1,           -- dump restart file interval
-- tmin      = 1,           -- first timestep to output
-- tmax      = tmax+1       -- last timestep to output
 --   }
-- }} 

-- scheme layout
layout = 'd3q19'
label = 'default'
-- Initial condition 
initial_condition = { pressure  = 1.0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

umax = 0.01

-- Boundary conditions
boundary_condition = {  
 { label = 'Channel', kind = 'wall'} 
,{ label = 'Cylinder', kind = 'wall'} 
,{ label = 'Inlet', 
  kind = 'inlet_ubb', 
   velocityX = --umax,
                {predefined = 'combined', 
                 transient = {predefined='smooth', min_factor=0.0, max_factor=umax,
                 from_time=0, to_time=100},
                 spatial = {predefined='parabol',  -- old values: center={-124.0, 0.335948, 0.335948 }
                            shape = { kind='canoND', 
                                      object = {center={-124.01562 , 0.320315, 0.320315 },
                                                vec={{0.0,0.0,0.0},{0.0,41.67187,0.0},{0.0,0.0,41.67187}}, 
                                      segments={100,100,100}}}                       -- segmentation in x,y,z direction
  --                          center={-124.01562 , 0.320315, 0.320315 }, halfvecA={0.0, 20.835935, 0.0}, halfvecB={0.0, 0.0, 20.835935}
                }},
   velocityY = 0.0, velocityZ = 0.0 }
,{ label = 'Outlet', 
   kind = 'outlet_expol',
   pressure = 1.0
 }
}

fluid = { omega = 1.8, rho0 = 1.0 }


-- Tracking              
tracking = {
  label = 'probe_press', 
   variable = {'pressure'},   -- options: pressure, velocity
   shape={kind='canoND', object ={ origin = {0.0,0.0,0.0}}},
   time = {min = 0, max = -1, interval = 1}, 
   format = 'ascii',
   folder = 'output/', 
 }

-- -- Tracking              
-- tracking = {
-- { label = 'probe_press_before', 
--   variables = {'density'}, 
--   type='point', point ={-80.35926, 0.320315, 0.320315},
--   interval = 1000, tmin = 1, tmax = -1
-- --  ,format='harvester', folder='tracking/'
--   }
-- ,
-- { label = 'probe_press_after', 
--   variables = {'density'}, 
--   type='point', point ={-66.4686, 0.320315, 0.320315},
--   interval = 1000, tmin = 1, tmax = -1
-- --  ,format='harvester', folder='tracking/'
--   }
-- }

restart = { ead = 'restart/lastHeader.lua',
            write = 'restart/',
            time = { min = 0, max = 10, interval = 1},
            buffer = 8000000 }
