require "common"
-- name of data file, which has pressure data

-- open datafile and get coordinates and density for point1 and point2
-- DATAFILE is a set up in evaluate.sh
io.input( os.getenv("DATAFILE") )

-- read in data
x1, y1, z1, den1 = io.read("*number", "*number", "*number", "*number" )
x2, y2, z2, den2 = io.read("*number", "*number", "*number", "*number" )

-- calculate the pressure slope using simulation results
sim = (den1-den2) / ( (x2-x1) / dx )

-- calculate the density slope of analytical solution
ana = D_slope

-- calculate error between simulation and analytical
err = math.abs( (sim - ana) / ana )

-- summary file which collects analysed results for all levels
-- SUMMARY is a set up in evaluate.sh
fout = io.open( os.getenv("SUMMARY"), 'a+' )

-- output the relative error to summary file
-- maxlevel is read from common.lua
-- print( "The error of level "..maxlevel.." is ",  err)
fout:write( maxlevel, "   ", sim, "   ", ana, "   ", err, "\n")
io.close( fout )
