#!/bin/bash
# Evaluate the current test case

# set up the path of executable
testcasename='2D Channel Flow'
seeder='../../../../seeder/build/seeder'
seederDebug='../../../../seeder/build/debug/seeder'
musubi='../../../build/musubi'
musubiDebug='../../../build/debug/musubi'

echo ---------------------------------------
echo Evaluating the $testcasename Test case.
echo Have fun!
echo ---------------------------------------
echo
rm tracking/*.lua
rm tracking/*.res

# mesh refinement level range
levelrange='6 7 8'
# temparory data file
export DATAFILE='tracking/datafile'
rm $DATAFILE
# summary file contains convergence result
export VELSUMMARY='tracking/vel_summary'
export WSSSUMMARY='tracking/wss_summary'
rm $SUMMARY
rm $VELSUMMARY
rm $WSSSUMMARY

for level in $levelrange;do
  export LEVEL=$level
  $seeder
  mpirun -n 4 $musubi
  # copy the last 1 lines of the track file to a temporary datafile
#tail -n 1 tracking/*vel_L${LEVEL}*.res >> $VELSUMMARY
  tail -n 2 tracking/*wss_l2norm_L${LEVEL}*.res >> $WSSSUMMARY
# lua analyse_velocity.lua
# lua analyse_wss.lua
# lua analyse_pressure.lua
done

cat $WSSSUMMARY
#cat $VELSUMMARY

# plot the error against to mesh refinement level
# gnuplot convergence_pre.gpl
# gnuplot convergence_vel.gpl
gnuplot convergence_wss.gpl
echo -----Testcase $testcasename refine LEVEL: $levelrange finished!------
