require "common"

debug_mode = false

sim_control = {
  time_control = {
    max = { iter = tmaxLB },
    interval = { iter = tmax/10 }
  }
}

variable = {
  -- boundary conditions
{
  name = 'vel_x',
  ncomponents = 1,
  vartype = 'st_fun',
  st_fun = {
    predefined = 'combined',
    temporal  = {
      predefined = 'smooth',
      min_factor = 0, max_factor = velMaxPhy,
      from_time = 0, to_time = tmaxPhy / 4,
    },
    spatial = {
      predefined = 'parabol',
      shape = {
        kind = 'canoND',
        object = {
          origin = { inlet_x, -R, dx/2},
          vec    = { 0.0,    2*R, 0.0 },
        },
      }, -- shape table
      amplitude = 1.0,
    } -- spatial table
  }, -- velX table
},
{ name = 'vel_y', ncomponents = 1, vartype = 'st_fun', st_fun = 0.0 },
{ name = 'vel_z', ncomponents = 1, vartype = 'st_fun', st_fun = 0.0 },
{ name = 'inlet_vel', ncomponents = 3, vartype = 'operation',
  operation = { kind = 'combine', input_varname = {'vel_x','vel_y','vel_z'}, },
},
{ name = 'pOutlet', ncomponents = 1, vartype = 'st_fun', st_fun = pOutlet, },
  -- analytical solution
  { name='vel_max',
    ncomponents=3,
    vartype = 'st_fun',
    st_fun  = { 1/velMaxPhy*dx, 1/velMaxPhy*dx, 1},
  },
  { name='vel_norm',
    ncomponents=3,
    vartype = 'operation',
    operation = {
      kind = 'multiplication',
      input_varname = { 'velocity_phy', 'vel_max'},
    },
  },
  { name='vel_an',
    ncomponents=1,
    vartype = 'st_fun',
    st_fun  = velA },
  { name='wss_an',
    ncomponents=1,
    vartype = 'st_fun',
    st_fun=wssA },
  { name='strain_rate_an',
    ncomponents=1,
    vartype='st_fun',
    st_fun=strainRateA },
  { name='p_an',
    ncomponents=1,
    vartype = 'st_fun',
    st_fun = pressureA },
  -- error
  { name='diff_wss',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = { 'wss_phy', 'wss_an'}
    },
  },
  { name='rel_diff_wss',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'rel_difference',
      input_varname = { 'wss_phy', 'wss_an'}
    },
  },
  { name='diff_vel',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = { 'vel_mag_phy', 'vel_an'}
    },
  },
  { name='rel_diff_vel',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'rel_difference',
      input_varname = { 'vel_mag_phy', 'vel_an'}
    }
  },
  { name='vel_magnitude',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'magnitude',
      input_varname = { 'velocity_phy'}
    }
  },
} -- variable

tracking = {
  { label = 'pressureDrop',
    variable = {
      'pressure_phy',
      'p_an',
      'velocity_phy',
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { -length/2, 0.0, dx/2 },
        vec = { length, 0.0, 0.0},
        segments = {200},
      },
    }, -- shape
    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=1}},
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },

  { label = 'strainRate_spatial',
    variable = {
      'strain_rate_phy',
      'strain_rate_an',
    },
    shape = { 
      kind = 'canoND',
      object = {
        origin = { 0.0, -height/2, dx/2},
        vec = { 0.0, height, 0.0},
        segments = {200} 
      }
    },
    time_control = {
      min = {iter=tmax},
      max = {iter=tmax},
      interval = {iter=1}
    },
    folder = './tracking/',
    output = { format = 'asciiSpatial', },
  },

{ label = 'wss_spatial',
  variable = {
    'wss_phy',
    'wss_an',
    'diff_wss',
    'rel_diff_wss',
  },
  shape = {
    kind = 'canoND',
    object = {
      origin = { 0.0, -height/2, dx/2},
      vec = { 0.0, height, 0.0},
      segments = {200}
    }
  },
  time_control = {
    min = {iter=tmax},
    max = {iter=tmax},
    interval = {iter=1},
  },
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},

{ label = 'wss_l2norm',
  variable = { 'rel_diff_wss'
  },
  shape = {
    kind = 'canoND',
    object = {
      origin = { 0.0, dx, dx/2},
      vec = { 0.0, R, 0.0},
      segments = {100}
    }
  },
  time_control = {
    min = { iter=tmax },
    max = { iter=tmax },
    interval = { iter=1 },
  },
  reduction = {'l2norm',},
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},

{ label = 'vel_spatial',
  variable = {
    'vel_mag_phy',
    'vel_an',
    'diff_vel',
    'rel_diff_vel',
    'vel_magnitude',
  },
  shape = { 
    kind = 'canoND',
    object = {
      origin = { 0.0, -height/2, dx/2},
      vec = { 0.0, height, 0.0},
      segments = {200} 
    }
  },
  time_control = { 
    min = {iter=tmax}, 
    max = {iter=tmax}, 
    interval = {iter=1} 
  },
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},

{ label = 'vel_l2norm',
  variable = { 'rel_diff_vel'
  },
  shape = {
    kind = 'canoND',
    object = {
      origin = { 0.0, -height/2, dx/2},
      vec = { 0.0, height, 0.0},
      segments = {100}
    }
  },
  time_control = { 
    min = {iter=tmax}, 
    max = {iter=tmax}, 
    interval = {iter=1} 
  },
  reduction = {'l2norm'},
  folder = './tracking/',
  output = {  format = 'asciiSpatial', },
},

  -- vel and pressure at inlet
{ label = 'inlet_spatial',
  variable = {
    'velocity_phy','vel_an','pressure_phy','strain_rate_phy','p_an'},
  shape = {
    kind = 'canoND',
    object = {
      origin = { -length/2+dx/2*3, -height/2, dx/2},
      vec = { 0.0, height, 0.0}, segments = {100}
    }
  },
  time_control = {
    min = { iter = tmax },
    max = { iter = tmax },
    interval = { iter = 1 },
  },
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},
  -- vel and pressure at outlet
{ label = 'outlet_spatial',
  variable = {
    'velocity_phy', 'vel_an','pressure_phy','strain_rate_phy','p_an' },
  shape = {
    kind = 'canoND',
    object = {
      origin = { length/2-dx/2*3, -height/2, dx/2},
      vec = { 0.0, height, 0.0}, segments = {100}
    },
  },
  time_control = {
    min = { iter = tmax },
    max = { iter = tmax },
    interval = { iter = 1 },
  },
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},
  -- global vel 
{ label = 'vel_global',
  variable = { 'vel_norm' },
  shape = { kind = 'global' },
  time_control = { min = { iter = tmax }, max = { iter = tmax }, interval = { iter = 1 }, },
  folder = './tracking/',
  output = { format = 'asciiSpatial', },
},

}   -- trakcing table

fluid = { omega = omega, rho0 = densityPhy }
physics = { dt = dt, rho0 = densityPhy, } -- physics table

initial_condition = {
  pressure = p0Phy,
  velocityX = 0, velocityY = 0.0, velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = 0, Syz = 0, Sxz = 0 }

identify = { kind = identify_kind, layout = layout, relaxation = relaxation, }

boundary_condition = {
  { label = 'outlet', kind = outlet_kind, pressure = 'pOutlet', },
  { label = 'top',    kind = wall_kind },
  { label = 'bottom', kind = wall_kind },
} -- boundary table

-- insert inlet to boundary table
if useVelocityInlet then
  table.insert( boundary_condition, -- velocity inlet
    { label = 'inlet', kind = inlet_kind,
      velocity = 'inlet_vel',
      -- velocityX = {
      --   predefined = 'combined',
      --   transient= {
      --     predefined = 'smooth',
      --     min_factor = 0, max_factor = velMaxPhy,
      --     from_time = 0, to_time = tmaxPhy / 4,
      --   },
      --   spatial = {
      --     predefined = 'parabol',
      --     shape = {
      --       kind = 'canoND',
      --       object = {
      --         origin = { inlet_x, -R, dx/2},
      --         vec    = { 0.0,    2*R, 0.0 },
      --       },
      --     } -- shape table
      --   } -- spatial table
      -- }, -- velX table
      -- velocityY = 0.0,
      -- velocityZ = 0.0,
    })
else
  table.insert(
    boundary_condition,
    { label = 'inlet', kind = inlet_kind,
      pressure = pInlet,
    }
  ) -- table insert
end
