#! /usr/bin/env python
import os
import logging
import string
import smtplib
import email
from email.MIMEMultipart import MIMEMultipart
from email.MIMEText import MIMEText
from email.MIMEBase import MIMEBase
from email import Encoders

# --------------------------------------------------------------
## To send Email
def send_mail(to,subject,text,attachments):

  COMMASPACE = ', '

  msg = MIMEMultipart()
  msg['From'] = 'jiaxing.qi@uni-siegen.de'
  msg['To'] = COMMASPACE.join(to)
  msg['Subject'] = subject
  msg.attach(MIMEText(text))

  for fil in attachments:
    part = MIMEBase('application', 'octet-stream')
    part.set_payload(open(fil,'rb').read())
    Encoders.encode_base64(part)
    part.add_header('Content-Disposition','attachment; filename="%s"' % os.path.basename(fil))
    msg.attach(part)
  try:
    server = smtplib.SMTP('mail.uni-siegen.de', 25)
    server.sendmail('jiaxing.qi@uni-siegen.de', to, msg.as_string())
    server.close()
    logging.info('Successfully send email to: '+msg['To'])
    print 'Successfully send email to: '+msg['To']
  except: 
    logging.error('Error: unable email')
    print 'Error: unable to send email'
