#!/bin/bash
# Evaluate the current test case

export LEVEL=6
export Re=30
export Mach=0.02
# export KIND="lbm"
# export MULTI="n"

# musubi=~/apes/musubi/build/debug/musubi
musubi=~/apes/musubi/build/musubi
seeder=~/apes/seeder/build/seeder
# Give your email here, results will be sent to your Email box
export email=jiaxing.qi@uni-siegen.de
#export email=raphael.haupt@student.uni-siegen.de

echo ------------------------------------------------------
echo Evaluating the Plain Channel 2D Test case.
echo                   Re: $Re
echo           Mesh level: $LEVEL
echo
echo Author: Jiaixng Qi
echo Have fun!
echo ------------------------------------------------------

if [ -z "$email" ]; then
  echo "Please input your email address:"
  read email_input
  export email=$email_input
fi

export prefix=L${LEVEL}_Re${Re}

# export results and pictures file names so gnuplot can also use them.
export vel_file=tracking/${prefix}_vel_spatial.res
export vel_global_file=tracking/${prefix}_vel_global.res
export wss_file=tracking/${prefix}_wss_spatial.res
export strain_file=tracking/${prefix}_strain_spatial.res
export p_file=tracking/${prefix}_p_spatial.res
export inlet_file=tracking/${prefix}_inlet_spatial.res
export outlet_file=tracking/${prefix}_outlet_spatial.res

export results_tar=${prefix}_results.tar

export vel_pic=pictures/${prefix}_vel_spatial.eps
export vel_global_pic=pictures/${prefix}_vel_global.eps
export wss_pic=pictures/${prefix}_wss_spatial.eps
export strain_pic=pictures/${prefix}_strain_spatial.eps
export p_pic=pictures/${prefix}_pressureDrop.eps
export vel_along_pic=pictures/${prefix}_vel_along.eps
export bc_vel_pic=pictures/${prefix}_bc_vel.eps
export bc_strain_pic=pictures/${prefix}_bc_strain.eps
export bc_p_pic=pictures/${prefix}_bc_p.eps

export musubi_log=logs/${prefix}_musubi.log
export seeder_log=logs/${prefix}_seeder.log

# create folders and delete old results files
echo "Create directory and delete old files"
[ -d mesh ]     && rm mesh/*     || mkdir mesh
[ -d tracking ] && rm tracking/* || mkdir tracking
[ -d pictures ] && rm pictures/* || mkdir pictures
[ -d output ]   && rm output/*   || mkdir output
[ -d logs ]     && echo 'logs folder found'     || mkdir logs
[ -d archives ] && echo 'archives folder found' || mkdir archives

# run Seeder
${seeder} | tee ${seeder_log}

# run Musubi
mpirun -n 2 ${musubi} | tee ${musubi_log}

# print important parameters
lua param.lua >> ${musubi_log}

# print velocity l2norm error
echo 'Velocity magnitude error l2norm across channel' >> ${musubi_log}
tail -n 2 tracking/*vel_l2norm*res >> ${musubi_log}

# print shear stress l2norm error
echo 'Shear stress error l2norm across channel' >> ${musubi_log}
tail -n 2 tracking/*wss_l2norm*res >> ${musubi_log}

# parallel simulation generates multiple files, combine them into one
cat tracking/*vel_spatial*res >> $vel_file
cat tracking/*vel_global*res >> $vel_global_file
cat tracking/*wss_spatial*res >> $wss_file
cat tracking/*strainRate_spatial*res >> $strain_file
cat tracking/*pressureDrop*res >> $p_file

cat tracking/*inlet_spatial*res >> $inlet_file
cat tracking/*outlet_spatial*res >> $outlet_file

# create results achivies
tar cvf ${results_tar} $vel_file
tar cvf ${results_tar} $vel_global_file
tar rvf ${results_tar} $wss_file
tar rvf ${results_tar} $strain_file
tar rvf ${results_tar} $inlet_file
tar rvf ${results_tar} $oulet_file
tar rvf ${results_tar} $p_file

# Call gnuplot to plot results
gnuplot plot_spatial.gpl

# Send pictures by email
python2.7 send_email.py
echo Channel 2D single run testcase finished!
echo
