-- Musubi configuration file. 

require "common" 

folderRead = 'restart_read/'
folderWrite = 'restart/'

inletBC = 'inlet_ubb'
outletBC = 'outlet_nrbc'
sideBC = 'wall' --'slip_wall'
southBC = sideBC
northBC = sideBC
topBC = sideBC
bottomBC = sideBC

-- Simulation name
simulation_name = 'channel3D'
logging = {level=3}
--mesh = 'mesh_sph/' -- Mesh information
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
control_routine = 'fast'
require_moments = true
-- Time step settigs
tmax_p = 1000 --s
tmax =  tmax_p/dt    -- total iteration number
interval_p = tmax_p/10
interval = interval_p/dt
sim_control = {
  time_control = { 
    max = {sim=tmax_p,iter=tmax}, 
    interval = {sim=interval_p,iter=interval}
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true
  }
}

estart = {
      ead = 'restart/channel3D_lastHeader.lua',
      write = 'restart/',
}


--balance = { active = false, dynamic = true, kind = 'levelwise',
--            time_control = { interval = {iter=3}, min = {iter=14}, max = {iter=tmax}}
--  }

--debug = { debugMode = true, debugFiles = true, debugNormal = true,
--          debugMesh = './debug/mesh_', debugStates = { 
--  write = {
--    folder    = './debug/',    -- the folder the restart files are written to
--    interval  = 1,           -- dump restart file interval
--    tmin      = 0,           -- first timestep to output
--    tmax      = tmax+1       -- last timestep to output
--    }
-- }} 


fluid = { 
        --omega_ramping = {predefined='smooth', min_factor = 0.5, 
        --                   max_factor=1.0, from_time=0, to_time=10000.0*dt}, 
           --kine_shear_viscosity = nu_phy,
           visc_spatial = { fun = omega_spatial, store = true},
           omega = omega,
           rho0 = rho0_p }

interpolation_method = 'linear'                     

-- Initial condition 
initial_condition = { 
                      pressure = ref_press, 
                      velocityX = u_inflow_simple,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {label='bgk',layout='d3q19', relaxation='mrt',
            kind = 'lbm_incomp'
            }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            
-- Boundary conditions
boundary_condition = {  
  {
    label = 'inlet', 
    kind = inletBC,
    velocityX = velocityX,
    velocityY = 0.0, velocityZ = 0.0
  },  
  {
    label = 'outlet',
    kind = outletBC,
    pressure = ref_press
  }, 
 }

if all_outlet then
elseif side_allslip then
  table.insert(boundary_condition, 
    { label = 'slip',  kind = sideBC, pressure = ref_press,
      velocityX = velocityX,
      velocityY = 0.0, velocityZ = 0.0
    })
else
  table.insert(boundary_condition, 
    { label = 'north',  kind = northBC, pressure = ref_press,
      velocityX = velocityX,
      velocityY = 0.0, velocityZ = 0.0
    })
  table.insert(boundary_condition, 
    { label = 'south', kind = southBC, pressure = ref_press,
      velocityX = velocityX,
      velocityY = 0.0, velocityZ = 0.0
    })
  table.insert(boundary_condition, 
    { label = 'top', kind = topBC, pressure = ref_press,
      velocityX = velocityX,
      velocityY = 0.0, velocityZ = 0.0
    })
  table.insert(boundary_condition, 
    { label = 'bottom', kind = bottomBC, pressure = ref_press,
      velocityX = velocityX,
      velocityY = 0.0, velocityZ = 0.0
    })
end

variable = {
  --analytic solution
--  { name='vel_an', 
--    ncomponents=1, 
--    vartype = 'st_fun',
--    st_fun = u_inflow },
  { name='vel_an_1', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = u_inflow_simple },
  { name='vel_an_2', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = u_inflow_complex_inner },
  { name='vel_an_3', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = u_inflow_complex_wall },
  { name='wss_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = wssA },
  { name='press_an', 
    ncomponents=1, 
    vartype = 'st_fun',
    st_fun = pressA },
    --error
  { name = 'diff_pressure', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'pressure_phy','press_an'}
    }
  },
  { name = 'diff_wss', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'wss_phy','wss_an'},
    }
  },
--  { name = 'diff_vel', 
--    ncomponents = 1,
--    vartype = 'operation',
--    operation = {
--      kind = 'difference',
--      input_varname = {'vel_mag_phy','vel_an'}
--    }
  { name = 'diff_vel_1', 
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag_phy','vel_an_1'}
    }
 },
  { name = 'diff_vel_2', 
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag_phy','vel_an_2'}
    }
 },
  { name = 'diff_vel_3', 
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag_phy','vel_an_3'}
    }
 },
}--variable

-- Tracking              
tracking = {
{
  label = 'hvs', 
  folder = 'tracking/',
 variable = {'pressure_phy','velocity_phy'}, 
 shape = {kind = 'all'},
 time_control = {min= {iter=tmax}, max = {iter= tmax}, interval = interval_p},
  format = 'hvs'      
},
{
  label = 'probe', 
  folder = 'tracking/',
 variable = {'pressure_phy','velocity_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5-offset,height*0.5-offset} } },
 time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
  format = 'ascii'      
},
--{
--  label = 'inlet', 
--  folder = 'tracking/',
-- variable = {'pressure_phy','velocity_phy'}, 
-- shape = {kind = 'canoND', object = {origin ={dx_half,-offset,-offset},
--                                     vec = {{0.0,height,0.0},
--                                            {0.0,0.0,height}},
--                                     segments = {nHeight+2,nHeight+2} }},
-- time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--  format = 'asciiSpatial'      
--},
--{
--  label = 'outlet', 
--  folder = 'tracking/',
-- variable = {'pressure_phy','velocity_phy'}, 
-- shape = {kind = 'canoND', object = {origin ={length-dx_half,-offset,-offset},
--                                     vec = {{0.0,height,0.0},
--                                            {0.0,0.0,height}},
--                                     segments = {nHeight+2,nHeight+2} }},
-- time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
--  format = 'asciiSpatial'      
--},
{
  label = 'press_line', 
  folder = 'tracking/',
 variable = {'pressure_phy','press_an', 'diff_pressure'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,height*0.5-offset,height*0.5-offset},
                                     vec = {length,0.0,0.0},
                                     segments = nLength+2} },
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{ label = 'press_l2norm',
  variable = {
    'diff_pressure', 
      'press_an',
              },
 shape = {kind = 'canoND', object = {origin ={0.0,height*0.5-offset,height*0.5-offset},
                                     vec = {length,0.0,0.0},
                                     segments = nLength+2} },
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  reduction = {'l2norm', 'l2norm'},
  folder = './tracking/',
  format = 'asciiSpatial',
},
{
  label = 'velProfile', 
  folder = 'tracking/',
  variable = {'vel_mag_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2}}},
 time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
  format = 'asciiSpatial'      
},
{ label = 'convergence',
  variable = {'pressure_phy','vel_mag_phy'}, 
  shape = {kind = 'all'}, 
  time_control = {min = 0, max = tmax_p, interval = 10*dt},
  format='convergence',
  reduction = {'average','average'},
  convergence = {norm='average', nvals = 100, absolute = true,
  condition = { threshold = 1.e-8, operator = '<=' }}
},
--{ label = 'wss_spatial',
--  variable = { 'wss_phy', 
--               'wss_an', 
--              'diff_wss'
--             },
--  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
--                                     vec = {{0.0,height,0.0},
--                                            {0.0,0.0,height}},
--                                     segments = {nHeight+2,nHeight+2} }},
--  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--  folder = './tracking/',
--  format = 'asciiSpatial',
--},
--
--{ label = 'wss_l2norm',
--  variable = {
--    'diff_wss',
--    'wss_an'
--              },
--  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
--                                     vec = {{0.0,height,0.0},
--                                            {0.0,0.0,height}},
--                                     segments = {nHeight+2,nHeight+2} }},
--  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--  reduction = {'l2norm', 'l2norm'},
--  folder = './tracking/',
--  format = 'asciiSpatial',
--},
{ label = 'vel_spatial',
  variable = {
    'vel_mag_phy',
    'vel_an_1',
    'vel_an_2',
    'vel_an_3'
              },
  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                     vec = {{0.0,height,0.0},
                                            {0.0,0.0,height}},
                                     segments = {nHeight+2,nHeight+2} }},
  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
  folder = './tracking/',
  format = 'asciiSpatial',
},
--{ label = 'vel_l2norm',
--  variable = {
--    'diff_vel',
--    'vel_an'
--              },
--  shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
--                                     vec = {{0.0,height,0.0},
--                                            {0.0,0.0,height}},
--                                     segments = {nHeight+2,nHeight+2} }},
--  time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
--  reduction = {'l2norm', 'l2norm'},
--  folder = './tracking/',
--  format = 'asciiSpatial',
--}
  { label = 'vel_l2norm_simple',
    variable = {
      'diff_vel_1',
      'vel_an_1'
                },
    shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                       vec = {{0.0,height,0.0},
                                              {0.0,0.0,height}},
                                       segments = {nHeight+2,nHeight+2} }},
    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
    reduction = {'l2norm', 'l2norm'},
    folder = './tracking/',
    format = 'asciiSpatial',
  },
  { label = 'vel_l2norm_complex_inner',
    variable = {
      'diff_vel_2',
      'vel_an_2'
                },
    shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                       vec = {{0.0,height,0.0},
                                              {0.0,0.0,height}},
                                       segments = {nHeight+2,nHeight+2} }},
    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
    reduction = {'l2norm', 'l2norm'},
    folder = './tracking/',
    format = 'asciiSpatial',
  },
  { label = 'vel_l2norm_complex_wall',
    variable = {
      'diff_vel_3',
      'vel_an_3'
                },
    shape = {kind = 'canoND', object = {origin ={length*0.5,-offset,zpos-offset},
                                       vec = {{0.0,height,0.0},
                                              {0.0,0.0,height}},
                                       segments = {nHeight+2,nHeight+2} }},
    time_control = { min = {iter=tmax}, max = {iter=tmax}, interval = {iter=tmax+1} },
    reduction = {'l2norm', 'l2norm'},
    folder = './tracking/',
    format = 'asciiSpatial',
  }
}
