-- Use this file as template. Do not modify this file for running some testcases

require "common"

west_label = 'inlet'
east_label = 'outlet'

if all_outlet then
  north_label = 'outlet'
  south_label = 'outlet'
  top_label = 'outlet'
  bottom_label = 'outlet'
elseif side_allslip then
  north_label = 'slip'
  south_label = 'slip'
  top_label = 'slip'
  bottom_label = 'slip'
else
  north_label = 'north'
  south_label = 'south'
  top_label = 'top'
  bottom_label = 'bottom'
end

folder = 'mesh/'
logging = {level=10}
ebug = {debugMode = true, debugFiles=true}

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.-offset,-dx/1.-offset},
               length = length_bnd}

minlevel = level

--  spatial object is composed by the attribute and Geometry

spatial_object = {
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 4*dx, height*0.5-offset, zpos },
        } --- object
    }
  },
  {
    attribute = {
      kind = 'boundary',  ---kind in attribute is seed/boundary/refinement/periodic
      label = north_label,     -- for north
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',    -- kind in geometry is canoND/sphere/stl 
      object = {
        origin = { -dx_eps,height+dx_eps-offset,-dx_eps-offset },
        vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,0.0,height+2.*dx_eps}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = south_label,   --- for south
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx_eps-offset,-dx_eps-offset},
        vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,0.0,height+2.*dx_eps}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = top_label
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx_eps-offset,height+dx_eps-offset},
        vec = {{length+2*dx_eps,0.0,0.0},
             {0.0,height+2*dx_eps,0.0}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = bottom_label
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx_eps-offset,-dx_eps-offset},
        vec = {{0.0,height+2*dx_eps,0.0},
               {length+2*dx_eps,0.0,0.0}}
      }
    }  
  },
  {
    attribute = {
      kind = 'boundary',
      label = west_label     --- for west
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx_eps-offset,-dx_eps-offset},
        vec = {{0.0,height+2*dx_eps,0.0},
               {0.0,0.0,height+2.*dx_eps}}
        }
    }
  },

  {
    attribute = {
      kind = 'boundary',
      label = east_label     --- for east
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx_eps-offset,-dx_eps-offset},
        vec = {{0.0,height+2*dx_eps,0.0},
               {0.0,0.0,height+2.*dx_eps}}
        }
    }
  },
}
