-- mesh level
level =  7
refinementLevel = 0
refinementLevel2 = 0
timing_file = 'sdr_timing.res'

-- rotation angle of the channel in degrees
angle =  8
label = 'channelD'..angle
timing_file = 'sdr_timing.res'

shepherd = true
if shepherd then
  stlFolder = '$!stl_path!$'
else
  stlFolder = 'stl/'
end
-- geometry definition
qValues = true
usePeriodic = false
useObstacle = false
case2d = true
obsCentered = true
if usePeriodic then
  case2d = true
end
walls = true

verbose = true
height = 1.   -- will be adapted to be exactly resolved by the discretization
ratio  = 25.  -- will be adapted to be exactly resolved by the discretization
length = ratio*height
radius = 0.1*height
fixHeight=true
if fixHeight then
  -- here should be the logic how to fix the height of the channel.
  -- probably define a number of elements in the height?
  -- such as 2^(level-4) 
  -- -> nH(l=7) = 8
  -- -> nH(l=8) = 16 ...
  nElemsHeight = 2^(level-4)
  dx = height/nElemsHeight
  nElemsLength = nElemsHeight*ratio + 2 -- need inlet and outlet element
  -- compute the required level by
  resizeFactor = (math.cos(angle*math.pi/180))
  level = math.ceil( math.log(nElemsLength)/resizeFactor/math.log(2))
  lengthSeeder = 2^level*dx
  print('nELemsheight '..nElemsHeight)
  print('nELemsLength '..nElemsLength)
  print('height       '..height      )
  print('length       '..length      )
  print('rot x-length '..length/math.cos(angle*math.pi/180))
  print('lengthSeeder '..lengthSeeder)
else
  -- computation of the discrete sizes.
  -- fixing the length and adapting the height to such a ratio
  -- that the half-height is always integer multiples of dx
  lengthSeeder = length/(1.-2./2.^level)
  dx  = lengthSeeder/(2^level)
  -- now adapt H
  nElemsHeight = 2.*math.floor(length/(dx*2.*ratio))
  height = nElemsHeight*dx
end

--
maxLevel = level+math.max(refinementLevel, refinementLevel2)
dxMin  = lengthSeeder/(2^maxLevel)
dxDash = 0.5*dxMin
heightLB = nElemsHeight
heightPhys = heightLB*dx
-- physical reference values
dxPhys = dx
lPhys = length  -- m
nElemsMax = nElemsLength

-- Use this file as template. Do not modify this file for running some testcases
folder = 'mesh/'

ebug = {debugMode = true, debugMesh = './prototree/', debugFiles = true}
logging = { level = 6 }
size_x = 0.1*length
start_x = -0.5*size_x
if useObstacle then
  size_x = 3.*radius
  start_x = -0.5*size_x
  size_y = 2.*height/5.-5.*dxDash
else
  size_y = height/5-5.*dxDash
end
start_y = -size_y/2
size_z = size_y
start_z = start_y

start2_x = -0.4*length
size2_x  = 0.45*size_x
size2_y = size_y*0.55
start2_y = -size2_y/2
size2_z = size2_y
start2_z = start2_y

if angle > 0 then
  translateX = 0.
  seedPosX = radius + 2.*dx
else
  seedPosX = 0.
  if ratio > 3. then
    translateX = -length*0.40
  else
    translateX = -length*0.05
  end
end
if obsCentered then
  translateY = 0.
else 
  translateY = 0.01*height
end
sc = 1.

bounding_cube = {
  origin = {-lengthSeeder*0.5, -lengthSeeder*.5, -lengthSeeder*0.5},
  length = lengthSeeder,
}
transformMatrix = {
  deformation = {
    { sc*math.cos(angle*math.pi/180), -sc*math.sin(angle*math.pi/180), 0.0 },
    { sc*math.sin(angle*math.pi/180),  sc*math.cos(angle*math.pi/180), 0.0 },
    { 0.0, 0.0, sc }
  } -- rotate the geometry in anti-clockwise direction along z-axis
}

minlevel=level
spatial_object = {
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel+level,
      label='box1'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start_x, start_y, start_z },
        vec = {{size_x, 0., 0.},
              {0.,size_y, 0.},
              {0., 0., size_z}}
      }
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel2+level,
      label='box2'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start2_x, start2_y, start2_z },
        vec = {{size2_x, 0., 0.},
              {0.,size2_y, 0.},
              {0., 0., size2_z}}
      }
    }
  },
  { attribute = { kind = 'seed', },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { seedPosX, 0., dx*0.5 },
      },
    },
    transformation = transformMatrix
  }, -- seed
  -- {
  --   attribute = {
  --     kind = 'boundary',
  --     label='east'
  --   },
  --   geometry = {
  --     kind = 'canoND',
  --     object = {
  --       origin = {length*0.5+dxDash, -length*0.5, -length*0.5},
  --       vec = {
  --         {0.0, length,     0.0 },
  --         {0.,     0.0,  length },
  --       }
  --     }
  --   },
  --   transformation = transformMatrix,
  -- },
  -- {
  --   attribute = {
  --     kind = 'boundary',
  --     label='west'
  --   },
  --   geometry = {
  --     kind = 'canoND',
  --     object = {
  --       origin = {-length*0.5-dxDash, -length*0.5, -length*0.5},
  --       vec = {{0.0, length, 0.},
  --             {0.,0.0, length}}
  --     }
  --   },
  --   transformation = transformMatrix,
  -- },
}


if case2d then
  depth = 1*dx
else
  depth=height
end

if usePeriodic == true then
  -- add periodic planes
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'boundary', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { -length, -length, depth+dxDash},
          vec = { { 2*length, 0.0, 0.0},
                  { 0.0, 2*length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { -length,  -length, -dxDash},
          vec = { { 0., 2*length, 0.0},
                  { 2*length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
else
  -- add frontback walls
  table.insert(spatial_object, {
    attribute = {
      kind  = 'boundary',
      label = 'frontback',
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = { -length, -length, depth/2+0.5*dx+dxDash},
          vec = { { 2*length, 0.0, 0.0},
                  { 0.0, 2*length, 0.0},}
        }, -- plane 1
        {
          origin = { -length, -length, -depth*0.5+0.5*dx-dxDash},
          vec = { { 2*length, 0.0, 0.0},
                  { 0.0, 2*length, 0.0},}
        }, -- plane 2
      }, -- object
    }, -- geometry
  })
end

if walls == true then
  scp = length*1.5
  transformPlanes = {
    { scp*math.cos(angle*math.pi/180), -scp*math.sin(angle*math.pi/180), 0.0 },
    { scp*math.sin(angle*math.pi/180),  scp*math.cos(angle*math.pi/180), 0.0 },
    { 0.0, 0.0, scp }
  }

  table.insert(spatial_object,  { 
    attribute = {
      kind = 'boundary',
      label='north', 
      calc_dist = qValues,
      --flood_diagonal = false
    },
    geometry = {
      kind = 'stl',
      object = { filename = stlFolder..'plane_ascii.stl', format = 'ascii'}
    },
    transformation = { deformation = transformPlanes,
      translation = { 0., height*0.5+dxDash, 0. }
     }
  })
  table.insert(spatial_object,  {
    attribute = {
      kind = 'boundary',
      label='south',
      calc_dist = qValues,
      flood_diagonal = false
    },
    geometry = {
      kind = 'stl',
      object = { filename = stlFolder..'plane_ascii.stl', format = 'ascii'}
    },
    transformation = { deformation = transformPlanes,
      translation = { 0., -(height*0.5+dxDash), 0. }
     }

  })
end

table.insert(spatial_object,  {
  attribute = {
    kind = 'boundary',
    label='east'
  },
  geometry = {
    kind = 'canoND',
    object = {
      origin = {length*0.5+dxDash, -length*0.5, -length*0.5},
      vec = {
        {0.0, length,     0.0 },
        {0.,     0.0,  length },
      }
    }
  },
  transformation = transformMatrix,
})
table.insert(spatial_object,  {
  attribute = {
    kind = 'boundary',
    label='west'
  },
  geometry = {
    kind = 'canoND',
    object = {
      origin = {-length*0.5-dxDash, -length*0.5, -length*0.5},
      vec = {{0.0, length, 0.},
            {0.,0.0, length}}
    }
  },
  transformation = transformMatrix,
})

if useObstacle ==true then
  if case2d then
    stlfile=stlFolder..'cylinder.stl'
    defZ = 1.
  else
    stlfile=stlFolder..'sphere.stl'
    defZ = radius
  end
  if qValues then
    table.insert(spatial_object,  { 
      attribute = { 
        kind = 'boundary', 
        level = maxLevel,
        label = 'sphere', 
        calc_dist = qValues,
      },
      geometry = {
        kind = 'stl',
        object = { filename = stlfile },
      },
      transformation = {
        deformation =  {radius,radius,defZ },
        translation =  {translateX, translateY, 0. }
      }
      }) 
  else
    table.insert(spatial_object,  { 
      attribute = { 
        kind = 'boundary', 
        level = maxLevel,
        label = 'sphere', 
        calc_dist = qValues,
      },
      geometry = {
        kind = 'cylinder', -- was: sphere
        object = {
          origin = {translateX,translateY,-lengthSeeder*0.5},
          vec = {0.0,.0,lengthSeeder}, -- length and axis of the cylinder
          radius = radius,
        }
      }
      })
  end
end
