-- Musubi configuration file. 
require 'seeder'

--flow parameters
nu_phy = 1e-3 --m^2/s
rho0_p = 1.0
rho0_L = 1.0
cs2 = 1.0/3.0

ref_press = 1.0
angular_vel = 1.0
Re = 10
u_ref = Re*nu_phy/(rad_outer-rad_inner)
angular_vel = u_ref/rad_inner

function u_analy(x,y,z) 
  r = math.sqrt(x^2+y^2)
  return u_ref*inner_to_outer_ratio*(rad_outer/r - r/rad_outer)/(1-inner_to_outer_ratio^2) 
end

function u_inflow(x,y,z,t) 
  return {-y*angular_vel, x*angular_vel, 0.0}
end
scaling = 'acoustic'

omega = 1.7
nu_L = (1.0/omega-0.5)/3.0
dt = nu_L*dx^2/nu_phy
u_ref_L = u_ref*dt/dx

innerBC = 'vel_dirichlet'
innerBC = 'inlet_bfl'
innerBC = 'vel_dirichlet'
outerBC = 'wall_libb'

-- Simulation name
simulation_name = 'cirularChannel'
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
control_routine = 'fast'
NOdebug = {logging = {level=1, filename='dbg', root_only=false}}
logging = {level=3}
-- Time step settigs
tmax_p = 100000*dt --s
tmax =  tmax_p/dt    -- total iteration number
interval_p = 1 -- s
interval = interval_p/dt
sim_control = {
  time_control = { 
    max = {sim=tmax_p}, 
    interval = {sim=interval_p}
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true,
    convergence = {
     variable = {'pressure_phy','vel_mag_phy'}, 
     shape = {kind = 'all'},
     time_control = {min = 1, max = tmax_p, interval = 10*dt},
     reduction = {'average','average'},
     norm='average', nvals = 50, absolute = true,
     condition = {
       { threshold = 1.e-12, operator = '<=' },
       { threshold = 1.e-12, operator = '<=' }}
    },
  }
}

restart = {
  NOread = 'restart/cirularChannel_lastHeader.lua',
  write = 'restart/',
}

fluid = { 
           omega = omega,
           rho0 = rho0_p }

interpolation_method = 'quadratic'

-- Initial condition 
initial_condition = { 
  pressure = ref_press, 
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0 
}

identify = {
  label='2D',
  layout='d2q9', 
  relaxation='mrt',
  kind = 'lbm_incomp'
}

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- Boundary conditions
boundary_condition = {  
  {
    label = 'inner', 
    kind = innerBC,
    velocity = u_inflow,
    curved = true,
  },  
  {
    label = 'outer',
    velocity = {0.0,0.0,0.0},
    curved =true,
    kind = outerBC,
  }, 
  {
    label = 'z_wall',
    kind = 'wall'
  }
}

variable = {
  { name='vel_an', 
    ncomponents=1, 
    vartype = 'st_fun', 
    st_fun=u_analy 
  },
}

-- Tracking              
tracking = {
--  {
--    label = 'probe', 
--    folder = 'tracking/',
--    variable = {'pressure_phy','velocity_phy'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={length*0.5,height*0.5,zpos} 
--      } 
--    },
--    time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
--    output = {format = 'ascii'}
--  },
  {
    label = 'vtk', 
    folder = 'tracking/',
    variable = {'pressure_phy','velocity_phy','vel_an'}, 
    shape = {kind = 'all'},
    time_control = {min= 0, max = tmax_p, interval = tmax_p/10},
    output = {format = 'vtk'}
  },
}
