----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from common.lua
require "common"

bc_inlet_H2O = 'spc_molefrac'
bc_inlet_Na = 'wall'
bc_inlet_Cl = 'wall'

bc_outlet_H2O = 'spc_vel_bb'
bc_outlet_Na = 'spc_vel_bb'
bc_outlet_Cl = 'spc_vel_bb'
--bc_outlet_H2O = 'spc_outlet_vel'
--bc_outlet_Na = 'spc_outlet_vel'
--bc_outlet_Cl = 'spc_outlet_vel'

bc_top_H2O = 'wall'
bc_top_Na = 'spc_molefrac'
bc_top_Cl = 'wall'

bc_bottom_H2O = 'wall'
bc_bottom_Na = 'wall'
bc_bottom_Cl = 'spc_molefrac'

bc_front = 'wall'
bc_back = 'wall'
bc_porous = 'wall_higher_order'
bc_extendedIO = 'wall'

--all wall
--bc_inlet_H2O = 'wall'
--bc_inlet_Na = 'wall'
--bc_inlet_Cl = 'wall'
--bc_outlet_H2O = 'wall'
--bc_outlet_Na = 'wall'
--bc_outlet_Cl = 'wall'
--bc_top_Na = 'wall'
--bc_bottom_Cl = 'wall'
--bc_porous = 'wall'

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'

io_buffer_size = 1
printRuntimeInfo = false
comm_reduced = false

-- Simulation name
simulation_name = simname
mesh = 'mesh/'

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'
scaling = 'diffusive'

ebug = {logging = {level=1, filename = 'dbg_bgk.out', root_only=false},
         debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval_p = tmax_p/100
tmax = 10000--tmax_p/dt
tmax_p = tmax*dt
interval = 1000
sim_control = {
  time_control = {
    min = 0 ,
    max = {sim=tmax_p,iter=tmax},
    interval = {sim=interval_p,iter=interval} 
  }
}


-- restart
restart = {
      --read = 'restart/porous_lastHeader.lua',
      --read = 'restart/taylorDispersion_header_15.000E+00.lua',
      write = 'restart/',
      --time_control = { min = 0, max = tmax_p, interval = {iter=interval}}
      time_control = {
        min = 0 ,
        max = {sim=tmax_p,iter=tmax},
        interval = {sim=interval_p,iter=interval*2} 
      }
}

physics = { --rho0 = rho0_p, 
            dt = dt, 
            moleDens0=moleDens0,
            molWeight0 = m_min 
          }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = 'bgk', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  mixture = { rho0 = rho0_p, moleDens0 = moleDens0,
              omega_diff = omega_diff,
              --paramB = 0.01,
              --kine_shear_viscosity = nu,
              omega_kine = 2.0,
              --bulk_viscosity = nu,
              theta_eq = 1.0,
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  
  -- user variable
  variable = {
    {
      name = 'ic_molefrac_H2O',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = {
        predefined = 'combined',
        ransient= {predefined='smooth', min_factor = 0.5, 
                    max_factor=1.0, from_time=0, to_time=tmax_p/10}, 
        spatial = IC_molefrac_H2O
      }
    },
    {
      name = 'ic_molefrac_Na',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = {
        predefined = 'combined',
        spatial = IC_molefrac_Na
      }
    },
    {
      name = 'ic_molefrac_Cl',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = {
        predefined = 'combined',
        spatial = IC_molefrac_Cl
      }
    },
    {
      name = 'vel_x',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_velocity
    },
    {
      name = 'vel_zero',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = 0.0
    },
    {
      name = 'bc_vel',
      ncomponents = 3,
      vartype = 'operation',
      operation = { 
        kind = 'combine',
        input_varname = {'vel_x','vel_zero','vel_zero'}
      }
    },
    {
      name = 'bc_top_molefrac_Na',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_top_moleFrac_Na
    },
    {
      name = 'bc_top_molefrac_Cl',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_top_moleFrac_Cl
    },
    {
      name = 'bc_top_molefrac_H2O',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_top_moleFrac_H2O
    },
    {
      name = 'bc_bottom_molefrac_Na',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_bottom_moleFrac_Na
    },
    {
      name = 'bc_bottom_molefrac_Cl',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_bottom_moleFrac_Cl
    },
    {
      name = 'bc_bottom_molefrac_H2O',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_bottom_moleFrac_H2O
    },
    {
      name = 'bc_inlet_moleflux_Na',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_inlet_moleFlux_Na
    },
    {
      name = 'bc_inlet_moleflux_Cl',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_inlet_moleFlux_Cl
    },
    {
      name = 'bc_inlet_moleflux_H2O',
      ncomponents = 1,
      vartype = 'st_fun',
      st_fun = BC_inlet_moleFlux_H2O
    },
  },

  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_moleFrac_H2O,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet_H2O,
       mole_fraction = 'ic_molefrac_H2O', 
       velocity = 'bc_vel',
       mole_flux = 'BC_inlet_moleflux_H2O',
       --order = 2
     },
     {
       label = 'outlet',
       kind = bc_outlet_H2O,
       velocity = 'bc_vel',
       mole_fraction = 'ic_molefrac_H2O'
     },
     {
       label = 'top',
       kind = bc_top_H2O,
       mole_fraction = 'bc_top_molefrac_H2O'
     },
     {
       label = 'bottom',
       kind = bc_bottom_H2O,
       mole_fraction = 'bc_bottom_molefrac_H2O'
     },
     { label = 'front', kind = bc_front},
     { label = 'back', kind = bc_back},
     { label = 'porous', kind = bc_porous},
     { label = 'extendedIO', kind = bc_extendedIO}
    }
  }--H2O
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_moleFrac_Na,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet_Na,
       mole_fraction = 'ic_molefrac_Na',
       velocity = 'bc_vel',

       moleflux = 'bc_inlet_moleflux_Na'
       --order = 2
     },
     {
       label = 'outlet',
       kind = bc_outlet_Na,
       velocity = 'bc_vel',
       mole_fraction = 'ic_molefrac_Na'
     },
     {
       label = 'top',
       kind = bc_top_Na,
       mole_fraction = 'bc_top_molefrac_Na'
     },
     {
       label = 'bottom',
       kind = bc_bottom_Na,
       mole_fraction = 'bc_bottom_molefrac_Na'
     },
     { label = 'front', kind = bc_front},
     { label = 'back', kind = bc_back},
     { label = 'porous', kind = bc_porous},
     { label = 'extendedIO', kind = bc_extendedIO}
    }
  }--Na
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_moleFrac_Cl,
      velocityX = IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet_Cl,
       mole_fraction = 'ic_molefrac_Cl',
       velocity = 'bc_vel',

       moleflux = 'bc_inlet_moleflux_Cl'
       --order = 2
     },
     {
       label = 'outlet',
       kind = bc_outlet_Cl,
       velocity = 'bc_vel',
       mole_fraction = 'bc_molefrac_Cl'
     },
     {
       label = 'top',
       kind = bc_top_Cl,
       mole_fraction = 'bc_top_molefrac_Cl'
     },
     {
       label = 'bottom',
       kind = bc_bottom_Cl,
       mole_fraction = 'bc_bottom_molefrac_Cl'
     },
     { label = 'front', kind = bc_front},
     { label = 'back', kind = bc_back},
     { label = 'porous', kind = bc_porous},
     { label = 'extendedIO', kind = bc_extendedIO}
    }
  } --Cl
  } --field
}--scheme
