-- load lua variables from common.lua
require "common"

-- Simulation name
simulation_name = simname
-- set the bounding cube
bounding_cube = {
  origin = {-dx, -dx, -dx},
  length = length_bnd, 
  }
-------------------------------------------
label = 'singleLevel'
-------------------------------------------
porous_origin = {
  porous_origin_original[1],
  porous_origin_original[2],
  porous_origin_original[3]
}

-------------------------------------------
-- some basic Seeder settings
comment = 'porous medium multispecies'
folder = 'mesh/'
logging = {level = 10}
stlfolder = './'
minlevel  = level
-------------------------------------------

spatial_object = {
  {
    -- Defining a seed to identify the part of the computational domain in
    -- the universe cube.
    attribute = { kind = 'seed' },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = {
                   { origin = {length-2*dx, height_Y/2.0, height_Z/2.0} },
                   { origin = {2*dx, height_Y/2.0, height_Z/2.0} }
                 }  
               } 
  },
  -- Inlet
  {
    attribute = { kind = 'boundary',
                  label = 'inlet',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = 
                   { -- inlet
                   origin = { -dx_half, -dx, -dx},
                   vec = {
                     {0.,height_Y+4*dx,0.,},
                     {0.,0., height_Z+4*dx}
                     }
                   } 
             }
  },  
  -- Outlet
  {
    attribute = { kind = 'boundary',
                  label = 'outlet',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = 
                   { -- outlet
                   origin = { length+dx_half, -dx -dx },
                   vec = {
                     {0.,height_Y+4*dx,0.,},
                     {0.,0., height_Z+4*dx}
                     }
                   }     
             }
  },
  -- separate top and bottom area in extended inlet and outlet
  {
    attribute = { kind = 'boundary',
                  label = 'extendedIO',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = { 
                   { -- y+
                   --bottom-inlet
                   origin = { -dx_half, -dx_half+dx_offset, -dx },
                   vec = {
                     {inlet_ext+dx,0.0,0.0},
                     {0., 0.0, height_Z+4*dx}
                     }
                   },
                   { -- y+
                   --bottom-outlet
                   origin = { length+dx_half, -dx_half+dx_offset, -dx },
                   vec = {
                     {-(outlet_ext+dx),0.0,0.0},
                     {0., 0.0, height_Z+4*dx}
                     }
                   },
                   { -- y+
                   --top-inlet
                   origin = { -dx, height_Y+dx_half-dx_offset, -dx },
                   vec = {
                     {inlet_ext+dx,0.0,0.0},
                     {0., 0.0, height_Z+4*dx}
                     }
                   },
                   { -- y+
                   --top-outlet
                   origin = { length+dx_half, height_Y+dx_half-dx_offset, -dx },
                   vec = {
                     {-(outlet_ext+dx),0.0,0.0},
                     {0., 0.0, height_Z+4*dx}
                     }
                   },
                 }
               }--- geometry
  },

  -- Top out
  {
    -- Defining a seed to identify the part of the computational domain in
    -- the universe cube.
    attribute = { kind = 'boundary',
                  label = 'top',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = 
                   { -- y+
                   origin = { inlet_ext, height_Y+dx_half-dx_offset, -dx },
                   vec = {
                     {porous_size[1],0.,0.0},
                     {0.,0., height_Z+4*dx}
                     }
                   }
               }
  }---end geomerty
,
  -- bottom out
  {
    attribute = { kind = 'boundary',
                  label = 'bottom',
                },
    geometry = { 
                 kind = 'canoND',
                 object = 
                   { -- y+
                   origin = { inlet_ext, -dx_half+dx_offset, -dx },
                   vec = {
                     {porous_size[1],0.,0.0},
                     {0.,0., height_Z+4*dx}
                     }
                 }
               }
  },
  -- front out
  {
    attribute = { kind = 'boundary',
                  label = 'front',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = 
                   { -- y+
                   origin = { -dx, -dx, -dx_half+dx_offset },
                   vec = {
                     {length+4*dx,0.0,0.0},
                     {0., height_Y+4*dx, 0.0}
                     }
                 }
               }
  }
,
  -- back out
  {
    attribute = { kind = 'boundary',
                  label = 'back',
                },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = 
                   { -- y+
                   origin = { -dx, -dx, height_Z+dx_half-dx_offset },
                   vec = {
                     {length+4*dx,0.0,0.0},
                     {0., height_Y+4*dx, 0.0}
                     }
                 }
               }--- geometry
  },
  {
    attribute = { kind = 'boundary',  -- or seed, refinement
                  label = 'porous',   -- some label to identify the boundary
                  level = maxLevel,   -- level to refine this object with,
                  calc_dist = qVals,
                  flood_diagonal = flood_diagonal
    },
                
    transformation = { 
      translation = { 
            -(porous_origin[1])+inlet_ext,
            -(porous_origin[2])+bottom_ext,
            -(porous_origin[3]) },
      deformation = scale      
    },  

    geometry = { -- Example for a sphere definition
      kind = 'stl',
      object = { filename = stlfolder..'porous.stl',
                 format = 'binary'
               }
   }
  }
}-- end


