-- all units are in physical units
-- length (m)
-- mesh info
refinement_factor = 3
length = 2*math.pi
nLength = refinement_factor*8
nWidth = 1
nDepth = 0
dx = length/nLength
--print(dx)
nLength_bnd = nLength + 2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

-- simulation params
tmax_p = 1.5
tmax = refinement_factor^2*200
-- time step size 
dt = tmax_p/tmax

-- molecular weights(kg/mol)
mH2O = 18.01528e-3 -- H20
mNa = 22.98977e-3 -- Na
-- For dilute case initial both two dilute species with same molecular weight
mCl = mNa --35.4527e-3  -- Cl
m_min = math.min(mH2O,mNa,mCl)

-- specific charge
charge_nr_H2O = 0.0
charge_nr_Na = 1.0
charge_nr_Cl = -1.0


-- diffusivities
-- diagonals are not important
-- largest diffusivities
--diff_diag = 1.0e-8
--diff_H2O_Na = 1.31570699e-9
--diff_H2O_Cl = 2.097388e-9
--diff_Na_Cl = 2.95407e-11
-- fake diffusivities
diff_diag = 1.0e-9
diff_H2O_Na = 1.31570699e-9
diff_H2O_Cl = 2.097388e-9
diff_Na_Cl = 2.95407e-11

-- density
rho0 = 1000.0 -- kg/m^3

-- shear viscosity
nu = 1e-6 --m^2/s
-- two smallness parameters to avoid division by zero
deltaRho1 = 0.001
deltaRho2 = 0.001
deltaRho3 = 0.001

---------------------------------------
-- Initial condition for dilute mixture
---------------------------------------
-- small parameter to control the behavior of the dominating solvent
tau = 0.0001

function diluteH2O(x,y,z)
  return tau*(math.sin(2*math.pi*x/length) + deltaRho1 + 1.0 )
end

function diluteNa(x,y,z)
  p1 = diluteH2O(x,y,z)
  return 0.5 + deltaRho2 - 0.5 * p1
end

function diluteCl(x,y,z)
  p1 = diluteH2O(x,y,z)
  return 0.5 - deltaRho2 - 0.5 * p1
end

molefrac_H2O = diluteH2O
molefrac_Na = diluteNa
molefrac_Cl = diluteCl
-- boundary condition
bc = {   
--                          { kind = 'wall',
--                            label = 'east'},
--                          { kind = 'wall',
--                            label = 'west'},
}
