plot  = []

## parameters
tau = 0.0001
mH2O = 18.01528e-3
mNa = 22.98977e-3
mCl = mNa
import math
xpos = 0.130900
diff_H2O_Na = 1.31570699e-5
diff_H2O_Cl = 2.097388e-5
omega = 0.95*math.pi
refNumDens = 1.0/1000.0
refMeter = 1.0
refSec = 1e-17
refVel = refMeter/refSec
deltaRho1 = 0.001
deltaRho2 = 0.001
length = 2.0*math.pi
n0 = 1000.0
faraday = 96485.34
# constant of the velocity term
#velConst = 2*deltaRho2/mNa
velConst = 2*deltaRho2*faraday*n0
# external electric field
E = 1e-3

show_plot = True
font_family= 'serif'
font_type= 'Times New Roman'
font_size = 16
figsize=[8,6]

infile = ['mix_point_*.res']

plot.append(dict(kind='xy', data=infile,
                 col=[1,7], npoints = 50, startplot = True,
                 label = 'LBM', ls = 'k^', lw = 2,
                 ))

plot.append(dict(kind='function', data=infile,
                 col=[1,5,6,7], points = 50, endplot = True,
                 fun = lambda *x: velConst*E*x[0]/x[1],
                 xmin = 0, xmax = 1.5, ymin = 0, ymax =  20,
                 xlabel = 'time [s]', ylabel = 'velocity [m/s]',
                 legendsize = 14, 
                 label = 'Analytic', ls = 'k', lw = 2))

plot.append(dict(kind='error', data=infile,
                 col=[1,7,5], npoints = 100, endplot = True, 
                 subplot = True, subaxes = [0.25,0.5,0.3,0.3],
                 reference = dict(kind='fun', 
                 fun = lambda *x: velConst*E*x[0]/x[2]),
                 #xlabel = 'time [$10^17s$]', ylabel = 'concentration [$mol/m^3$]',
                 #legendsize = 14, legend_loc = 1,
                 xmin = 0, xmax = 1.5, ymin = -0.0015, ymax = 0.0015,
                 xticks = [0,0.5,1.0,1.5], yticks=[-1.5e-3,-7.5e-4,-0.0,7.5e-4,1.5e-3],
                 label = 'Deviation', legend_loc = 2,
                 ls = 'k', 
                 figname = 'dilute_mixVelComparisonFixedPos', format = 'pdf'
                 ))

