import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'error_analysis'

run_seeder = True
run_seeder = False

run_musubi = True
run_musubi = False

submit_job = True
submit_job = False

run_gleaner = False
run_gleaner = True

height = 0.4e-3
dx_max = height/8
shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = run_seeder,
                          run_command = '',
                          params = [['dx', dx_max, dx_max/2**1, dx_max/2**2, dx_max/2**3, dx_max/2**4, dx_max/2**5 ],
                          #params = [['dx', dx_max/2**5],
                                    ['bc_type','moments','BounceBack']],
                                    #['bc_type','moments']],
                          additional_params = dict(MESH='mesh/', height = 0.4e-3),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = run_musubi,
                          run_command = 'mpirun -np 8',
                          params = [["omega_diff", 2.0] 
                                   ],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=None,
                          template='horus.template',
                          extension='sh',
                          run_exec = submit_job,
                          run_command = 'sbatch',
                          params = [[( "NPROCS", "NODES"),
                                     ( 12,        1)]
                                   ],
                          create_dir = False,
                          create_depend_path = True,
                          depend = ['musubi'],
                          label = 'horus'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot_error.py',
                          extension='py',
                          run_exec = run_gleaner,
                          run_command = '',
                          additional_params = dict(show_plot=True),
                          depend = ['seeder','musubi'],
                          #depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

