plot  = []

show_plot = True
font_family= 'serif'
font_size = 12
figsize = [5,4]

musubi_path = '$!musubi_path!$'

moleflux = musubi_path+'/tracking/stefantube_mix_line_p*_t*.res'
reference = musubi_path+'/maxwell_stefan_reference.res'

plot.append(dict(kind='xy', data=[moleflux], 
                 row=[1,-1],col=[1,4], startplot = True,
                 convert = True, facs=[1.0/0.238, 1],
                 label='Acetone',ls = 'k-')) 

plot.append(dict(kind='xy', data=[moleflux],
                 convert = True, facs=[1.0/0.238, 1],
                 row=[1,-1],col=[1,5], label='Methanol',ls = 'k--'))

plot.append(dict(kind='xy', data=[moleflux],
                 convert = True, facs=[1.0/0.238, 1],
                 row=[1,-1],col=[1,6], label='Air',ls = 'k-.'))

plot.append(dict(kind='xy', data=[reference],
                 npoints = 20,
                 row=[1,-1],col=[1,2], label='Acetone (shooting)',ls = 'kx'))

plot.append(dict(kind='xy', data=[reference],
                 npoints = 20,
                 row=[1,-1],col=[1,3], label='Methanol (shooting)',ls = 'ks'))

plot.append(dict(kind='xy', data=[reference],
                 npoints = 20,
                 row=[1,-1],col=[1,4], endplot = True,
                 label='Air (shooting)',ls = 'kd', xlabel='length (m)', 
                 ylabel ='mole fraction ($\chi_i =n_i/n_t$)',
                 xmin=0,xmax=1.0,ymin=0.0,ymax=1.0,
                 legend = dict(loc=2),
                 format = 'pdf', figname = 'stefantube', dpi=100))


