----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
scheme_kind = 'bgk'
tracking_fol = './'--tracking_'..scheme_kind..'/'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'multispecies'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

scaling = 'diffusive'

ogging = {level=10}
ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/10

sim_control = {
  time_control = {
    max = tmax_p, 
    interval = interval 
  }
}  

physics = { rho0 = rho0_p, 
            dt = dt, 
            --molWeigh0 = m_min,
            moleDens0 = 1000.0
}

-- model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    relaxation = scheme_kind, 
    --relaxation = 'mrt', 
-- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}
mixture = { rho0 = rho0_p, moleDens0 = 1000.0, 
            omega_diff = 2.0,
            theta_eq = 0.0,
            --kine_shear_viscosity = nu_p,
            --bulk_viscosity = 1e6,
            omega_kine = 2.0,
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
          }
-- field which defines fluid or specie
-- Single fluid simulation
field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
-- Initial condition
   ,initial_condition = { 
       density = molefrac_H2O,
       mole_fraction = molefrac_H2O,
       velocityX = 0.0,--TGV_velocityX,
       velocityY = 0.0,--TGV_velocityY,
       velocityZ = 0.0}
   }
 ,{
   label = 'Na'
  ,species = { molweight = mNa, diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
  ,initial_condition = {
       density = molefrac_Na,
       mole_fraction = molefrac_Na,
       velocityX = 0.0,--TGV_velocityX,
       velocityY = 0.0,--TGV_velocityY,
       velocityZ = 0.0}
  } --label Na end
 ,{
   label = 'Cl'
  ,species = { molweight = mCl, diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag } }
  ,initial_condition = {
       density = molefrac_Cl,
       mole_fraction = molefrac_Cl,
       velocityX = 0.0,--TGV_velocityX,
       velocityY = 0.0,--TGV_velocityY,
       velocityZ = 0.0}
  } --label cl end
}
-- add initial condition to variable system
variable = { name = 'initialMoleFrac', 
  ncomponents = 1, 
  vartype = 'st_fun',
  st_fun = { 
    { predefined = 'combined', spatial = molefrac_H2O },
    { predefined = 'combined', spatial = molefrac_Na },
    { predefined = 'combined', spatial = molefrac_Cl }
  }
}

tracking = {
  {
   label = 'line', 
   variable = {'H2O_mole_density_phy','Na_mole_density_phy','Cl_mole_density_phy',
               'density','density_phy',
               'H2O_mole_fraction','Na_mole_fraction','Cl_mole_fraction','mole_fraction'},
   folder = tracking_fol,
   shape = {kind = 'canoND', object= {origin={0.0,dx/2.0,dx/2},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   output={format = 'asciiSpatial'},
   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
  }
  ,
  {
   label = 'point', 
   variable = {'H2O_mole_density_phy','Na_mole_density_phy','Cl_mole_density_phy','mole_density_phy',
               'H2O_mole_fraction','Na_mole_fraction','Cl_mole_fraction','mole_fraction'},
   folder = tracking_fol,
   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
   shape = {kind = 'canoND', object= {origin={3.036873,dx/2.,dx/2.}}},
   output={format = 'ascii'},
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  }
}
