----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
bc_outlet = 'spc_outlet_expol'
bc_inlet = 'spc_inlet_ubb'
-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'spacer'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/20
sim_control = {
  time_control = {
    min =0,
     max = tmax_p,
      interval =interval}}

tmax_int = 100
interval_int = tmax_int/10
sim_control = {
  time_control = {
     min = {iter = 0},
      max = {iter = tmax_int},
       interval = {iter = interval_int }}
       }

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      --relaxation = 'bgk', 
      relaxation = 'bgk_forcing', 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  physics = { rho0 = rho0_p, 
              dt = dt, 
              molWeigh0 = m_min },

  external_force = { electric_field = {kind = 'const', const = {0.0,5e-8,0.0}}},

  mixture = { rho0 = rho0_p, moleDens0 = 1000.0,
              omega_diff = omega_diff,
              kine_shear_viscosity = nu_phy,
              --omega_kine = omega_kine,
              theta_eq = 1.0,
              bulk_viscosity = 1e-7,
              temp = 293.15,
              electricField = { 0.0, 5e-8, 0.0},
              gravityField = { 0.0, 0.0, 0.0},
              initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, 
                diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl},
                charge_nr = charge_nr_H2O}
-- Initial condition
   ,initial_condition = { 
      molefraction = IC_H2O,
      velocityX = 0.0,--IC_velocity,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet,
       molefraction = BC_H2O,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
     },
     {
       label = 'outlet',
       kind = bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       pressure = 0.0
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'spacer', kind = 'wall'}
    }
  }
 ,{
    label = 'Na'
   ,species = { molweight = mNa, 
                diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl },
                charge_nr = charge_nr_Na}
   ,initial_condition = {
      molefraction = IC_Na,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet,
       molefraction = BC_Na,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
     },
     {
       label = 'outlet',
       kind =  bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       pressure = 0.0
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'spacer', kind = 'wall'}
    }
  }
 ,{
    label = 'Cl'
   ,species = { molweight = mCl, 
                diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag },
                charge_nr = charge_nr_Cl}
   ,initial_condition = {
      molefraction = IC_Cl,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = bc_inlet,
       molefraction = BC_Cl,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       --order = 2
     },
     {
       label = 'outlet',
       kind =  bc_outlet,
       velocityX = BC_velocity,
       velocityY = 0.0,
       velocityZ = 0.0,
       pressure = 0.0
     },
     { label = 'north', kind = 'wall'},
     { label = 'south', kind = 'wall'},
     { label = 'spacer', kind = 'wall'}
    }
  } -- cl
  } -- field
}

restart = {
      ead = 'restart/spacer_lastHeader.lua',
      write = 'restart/',
      time_control = { min= {iter = 0}, max ={iter= tmax_p}, interval={iter =
        tmax_p/20}},
      time_control = { min= {iter = 0}, max ={iter= tmax_int}, interval={iter=
        tmax_int}}
}

