-- all units are in physical units
-- length (m)
-- mesh info
-- length of the diffusion tube
length = 0.238 --m
nLength = 60*1
nWidth = 2
nDepth = 2
dx = length/nLength
nLength_bnd = nLength + 2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

-- simulation params
tmax_p = 1000.00
tmax = 1000
-- time step size 
dt = 1e-1--tmax_p/tmax
tmax = tmax_p/dt

-- Stefan tube testcase parameters
-- REF: Multicomponent Mass Transfer - R. Taylor, R. Krishna. Pg. 21
-- molecular weights(kg/mol)
mAir = 28.96e-3 
mAcetone = 58.08e-3
mMethanol = 32.04e-3
-- binary diffusivities in m^2/s
diff_diag = 1e-4 --dummy
diff_Ace_Met = 8.48e-6
diff_Ace_Air = 13.72e-6
diff_Met_Air = 19.91e-6

-- pressure in vapor phase
pressure = 99.4e3 --Pa (N/m^2)
-- Temperature in vapor phase
temp = 328.5 --K

-- density
rho0 = 1.0 -- kg/m^3
-- shear viscosity
nu = 3e-4 --m^2/s

-- smallness parameters to avoid division by zero
delta = 0.0001

---------------------------------------
-- Boundary condition for stefan tube
---------------------------------------
-- At Inlet, x=0:
moleFrac_Ace_In = 0.319
moleFrac_Met_In = 0.528
moleFrac_Air_In = 1.0 - ( moleFrac_Ace_In + moleFrac_Met_In )

-- At outlet, x=length:
moleFrac_Ace_Out = delta
moleFrac_Met_Out = delta
moleFrac_Air_Out = 1.0 - ( moleFrac_Ace_Out + moleFrac_Met_Out )

---------------------------------------
-- Initial condition for stefan tube
---------------------------------------
function IC_Acetone_Linear(x,y,z)
  return moleFrac_Ace_In * (1.0 - x/length) + moleFrac_Ace_Out
end

function IC_Acetone_Smooth(x,y,z)
  return moleFrac_Ace_In * 0.5 * (1.0 - math.tanh((x-length/2.0)/dx)) + delta
end

function IC_Methanol_Linear(x,y,z)
  return moleFrac_Met_In * (1.0 - x/length) + moleFrac_Met_Out
end

function IC_Methanol_Smooth(x,y,z)
  return moleFrac_Met_In * 0.5 * (1.0 - math.tanh((x-length/2.0)/dx)) + delta
end

function IC_Air_Linear(x,y,z)
  ic_ace = moleFrac_Ace_In * (1.0 - x/length) + moleFrac_Ace_Out
  ic_met = moleFrac_Met_In * (1.0 - x/length) + moleFrac_Met_Out
  return 1.0 - ( ic_ace + ic_met )
end

function IC_Air_Smooth(x,y,z)
  ic_ace = moleFrac_Ace_In * 0.5 * (1.0 - math.tanh((x-length/2.0)/dx)) + delta
  ic_met = moleFrac_Met_In * 0.5 * (1.0 - math.tanh((x-length/2.0)/dx)) + delta
  return 1.0 - ( ic_ace + ic_met )
end


-- boundary condition
bc = {   
--   { kind = 'wall',
--     label = 'east'},
--   { kind = 'wall',
--     label = 'west'},
}
