----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'stefantube'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

scaling = 'diffusive'

ebug = {logging = {level=1, filename='dbg_new'},
         debugMode = true, 
         debugFiles = true, 
         verbose =  true, 
         verboseLevel = 100}

-- Time step settings
interval = tmax_p/10
sim_control = {
  time_control = {
    min = 0,
    max = {sim=tmax_p},
    interval = interval
  }
}
--time = {useIterations = true,
--        min = 0, max = 1, interval = 1 }

physics = { rho0 = rho0, 
            dt = dt, 
            moleDens0 = 1000.0
            --molWeigh0 = math.min(mAir,mAcetone,mMethanol)
            }
-- scheme model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    relaxation = 'bgk', 
    --relaxation = 'mrt', 
-- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}

-- user variables
variable = {
  {
    name = 'inlet_Acetone',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Ace_In
  },
  {
    name = 'inlet_Methanol',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Met_In
  },
  {
    name = 'inlet_Air',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Air_In
  },
  {
    name = 'outlet_Acetone',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Ace_Out
  },
  {
    name = 'outlet_Methanol',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Met_Out
  },
  {
    name = 'outlet_Air',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = moleFrac_Air_Out
  },
  {
    name = 'inlet_moleflux_Air',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {0.0,0.0,0.0}
  }
}

mixture = { rho0 = rho0, moleDens0 = 1000.0, 
            omega_diff = 2.0,
            --kine_shear_viscosity = nu_p,
            omega_kine = 2.0,
            theta_eq = 0.0,
            initial_condition = { pressure = 0.0}--TGV_kinematicPressure }
          }
-- field which defines fluid or specie
-- Single fluid simulation
field = {{
  label = 'Acetone'
-- species properties
   ,species = { molweight = mAcetone, 
                diff_coeff = { diff_diag, diff_Ace_Met, diff_Ace_Air } }
-- Initial condition
   ,initial_condition = { 
      mole_fraction = IC_Acetone_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       ind = 'wall',
       kind = 'spc_molefrac',
       mole_fraction = 'inlet_Acetone'
     },
     {
       label = 'outlet',
       ind = 'wall',
       kind = 'spc_molefrac',
       mole_fraction = 'outlet_Acetone'
     }
    }
  }
 ,{
    label = 'Methanol'
   ,species = { molweight = mMethanol, 
                diff_coeff = { diff_Ace_Met, diff_diag, diff_Met_Air } }
   ,initial_condition = {
      mole_fraction = IC_Methanol_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       ind = 'wall',
       kind = 'spc_molefrac',
       mole_fraction = 'inlet_Methanol'
     },
     {
       label = 'outlet',
       ind = 'wall',
       kind = 'spc_molefrac',
       mole_fraction = 'outlet_Methanol'
     }
    }
  }
 ,{
    label = 'Air'
   ,species = { molweight = mAir, 
                diff_coeff = { diff_Ace_Air, diff_Met_Air, diff_diag } }
   ,initial_condition = {
      mole_fraction = IC_Air_Linear,
      velocityX = 0.0,
      velocityY = 0.0,
      velocityZ = 0.0
    }
   ,boundary_condition = {
     {
       label = 'inlet',
       kind = 'spc_moleflux',
       mole_flux = 'inlet_moleflux_Air',
     },
     {
       label = 'outlet',
       kind = 'spc_molefrac',
       mole_fraction = 'outlet_Air',
     }
    }

  }
}

tracking = {
  {
   label = 'line', 
   variable = {'Acetone_mole_fraction','Methanol_mole_fraction',
               'Air_mole_fraction','mole_fraction'},
   folder = './',
   shape = {kind = 'canoND', object= {origin={0.0,dx,dx},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   output={format = 'asciiSpatial'},
   time_control = {min = tmax_p, max = tmax_p, interval = tmax_p}, 
  },
--  {
--   label = 'point', 
--   variable = {'Acetone_mole_fraction','Methanol_mole_fraction','Air_mole_fraction',
--               'Acetone_mole_flux_phy','Methanol_mole_flux_phy','Air_mole_flux_phy',
--               'mole_flux','velocity'},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={length-dx/2.,dx,dx} } },
--   eduction = {'average','average','average',
--                'average','average','average'},    
--   output={format = 'ascii'},
--   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
--  }

}
